/*
 * Decompiled with CFR 0.152.
 */
package im.crisp.client.external.notification;

import android.annotation.SuppressLint;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.TaskStackBuilder;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.RemoteMessage;
import im.crisp.client.R;
import im.crisp.client.external.ChatActivity;
import im.crisp.client.external.Crisp;
import im.crisp.client.external.Logger;
import im.crisp.client.internal.L.d;
import im.crisp.client.internal.L.i;
import im.crisp.client.internal.network.events.inbound.SessionJoinedEvent;
import im.crisp.client.internal.z.o;
import java.util.Map;
import java.util.Objects;

public final class CrispNotificationClient {
    private static final int a = 1;
    private static final String b = "title";
    private static final String c = "body";
    private static final String d = "website_id";
    private static final String e = "session_id";
    private static final String f = "sender";
    private static final String g = "crisp";
    private static final String h = "com.google.firebase.messaging.default_notification_icon";
    private static final String i = "com.google.firebase.messaging.default_notification_color";

    public static void c(@NonNull Context context, @NonNull String string2, @NonNull String string3) {
        Crisp.a(Logger.Level.INFO, "Crisp", "FCM init");
        FirebaseMessaging.getInstance().setAutoInitEnabled(true);
        CrispNotificationClient.a(context, string2, string3);
    }

    private static void a(@NonNull Context object, @NonNull String string2, @NonNull String string3) {
        im.crisp.client.internal.b.b b2;
        if (Build.VERSION.SDK_INT >= 26 && (b2 = im.crisp.client.internal.b.b.a(object)).a(string2) < 1) {
            NotificationChannel notificationChannel;
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)object);
            Object object2 = notificationChannel;
            Context context = object;
            NotificationChannel notificationChannel2 = object2;
            Context context2 = object;
            NotificationChannel notificationChannel3 = object2;
            Context context3 = object;
            object = context3.getString(R.string.crisp_sdk_notification_channel_id, new Object[]{string2});
            notificationChannel3((String)object, (CharSequence)context3.getString(R.string.crisp_sdk_notification_channel_name, new Object[]{string3}), 4);
            notificationChannel3.setLockscreenVisibility(0);
            notificationChannel3.setShowBadge(false);
            notificationChannel2.setSound(CrispNotificationClient.d(context2), new AudioAttributes.Builder().setUsage(5).build());
            notificationChannel2.enableVibration(true);
            notificationChannel2.enableLights(true);
            notificationChannel.setLightColor(CrispNotificationClient.a(context, string2));
            notificationManagerCompat.createNotificationChannel(notificationChannel);
            object = Logger.Level.INFO;
            string3 = "Crisp";
            object2 = new StringBuilder().append("Notification channel created for website");
            String string4 = Crisp.e().isAtLeast(Logger.Level.DEBUG) ? " " + string2 : "";
            Crisp.a((Logger.Level)((Object)object), string3, ((StringBuilder)object2).append(string4).toString());
            b2.a(string2, 1);
        }
    }

    public static boolean a() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            Crisp.a(Logger.Level.WARN, "Crisp", "Firebase is not configured, notifications are disabled.");
            return false;
        }
        return true;
    }

    public static boolean e(@NonNull Context context) {
        return Build.VERSION.SDK_INT < 33 || im.crisp.client.internal.L.i.a().a(context, "android.permission.POST_NOTIFICATIONS");
    }

    public static void a(@NonNull b b2) {
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(object -> {
            String string2 = null;
            if (object.isSuccessful() && (string2 = (String)object.getResult()) != null) {
                object = Logger.Level.INFO;
                String string3 = "Crisp";
                StringBuilder stringBuilder = new StringBuilder().append("FCM registration token fetched");
                String string4 = Crisp.e().isAtLeast(Logger.Level.DEBUG) ? " " + string2 : "";
                Crisp.a((Logger.Level)((Object)((Object)object)), string3, stringBuilder.append(string4).toString());
            } else {
                object = (object = object.getException()) != null ? object.getLocalizedMessage() : null;
                Logger.Level level = Logger.Level.WARN;
                String string5 = "Crisp";
                StringBuilder stringBuilder = new StringBuilder().append("FCM registration token fetch failed");
                object = object != null ? " (cause: " + (String)object + ')' : "";
                Crisp.a(level, string5, stringBuilder.append((String)object).toString());
            }
            b2.a(string2);
        });
    }

    public static void sendTokenToCrisp(@NonNull Context context, @NonNull String string2) {
        if (im.crisp.client.internal.b.a.a(context).e(string2)) {
            Crisp.a(context, string2);
        }
    }

    public static boolean isCrispIntent(@NonNull Intent intent) {
        return g.equals(intent.getStringExtra(f));
    }

    public static boolean isCrispNotification(@NonNull RemoteMessage remoteMessage) {
        return g.equals((String)remoteMessage.getData().get(f));
    }

    public static boolean isSessionExist(@NonNull Context object, @NonNull Intent intent) {
        Context context = object;
        Intent intent2 = intent;
        object = intent2.getStringExtra(d);
        return CrispNotificationClient.e(context, (String)object, intent2.getStringExtra(e));
    }

    private static boolean e(@NonNull Context object, @Nullable String string2, @Nullable String string3) {
        if (string2 == null) {
            return false;
        }
        object = (object = im.crisp.client.internal.b.a.a((Context)object).a(string2)) != null ? ((SessionJoinedEvent)object).p() : null;
        return Objects.equals(string3, object);
    }

    public static boolean isCurrentSession(@NonNull Context object, @NonNull Intent intent) {
        Context context = object;
        Intent intent2 = intent;
        object = intent2.getStringExtra(d);
        return CrispNotificationClient.d(context, (String)object, intent2.getStringExtra(e));
    }

    private static boolean d(@NonNull Context object, @Nullable String string2, @Nullable String string3) {
        im.crisp.client.internal.b.a a2 = im.crisp.client.internal.b.a.a(object);
        object = a2.y();
        Object object2 = a2.t();
        object2 = object2 != null ? ((SessionJoinedEvent)object2).p() : null;
        return Objects.equals(string2, object) && Objects.equals(string3, object2);
    }

    public static String getWebsite(@NonNull Intent intent) {
        return intent.getStringExtra(d);
    }

    public static String a(@NonNull Intent intent) {
        return intent.getStringExtra(e);
    }

    public static void handleNotification(@NonNull Context context, @NonNull RemoteMessage remoteMessage) {
        CrispNotificationClient.handleNotification(context, remoteMessage, null, true);
    }

    public static void handleNotification(@NonNull Context context, @NonNull RemoteMessage remoteMessage, boolean bl) {
        CrispNotificationClient.handleNotification(context, remoteMessage, null, bl);
    }

    public static void handleNotification(@NonNull Context context, @NonNull RemoteMessage remoteMessage, @Nullable TaskStackBuilder taskStackBuilder) {
        CrispNotificationClient.handleNotification(context, remoteMessage, taskStackBuilder, true);
    }

    @SuppressLint(value={"MissingPermission"})
    public static void handleNotification(@NonNull Context object, @NonNull RemoteMessage object2, @Nullable TaskStackBuilder object3, boolean bl) {
        NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)object);
        if (notificationManagerCompat.areNotificationsEnabled() && CrispNotificationClient.e(object)) {
            StringBuilder stringBuilder;
            RemoteMessage remoteMessage = object2;
            Map map = remoteMessage.getData();
            object2 = (String)map.get(b);
            String string2 = (String)map.get(c);
            String string3 = (String)map.get(d);
            String string4 = (String)map.get(e);
            long l2 = remoteMessage.getSentTime();
            if (!CrispNotificationClient.e(object, string3, string4)) {
                object = Logger.Level.WARN;
                object2 = "Crisp";
                object3 = new StringBuilder().append("Notification session ");
                String string5 = Crisp.e().isAtLeast(Logger.Level.DEBUG) ? string4 + " (website: " + string3 + ") " : "";
                Crisp.a((Logger.Level)((Object)object), (String)object2, ((StringBuilder)object3).append(string5).append("not found, ignoring...").toString());
                return;
            }
            Object object4 = object;
            String string6 = object4.getString(R.string.crisp_sdk_notification_channel_id, new Object[]{string3});
            int n2 = CrispNotificationClient.c(object4);
            int n3 = CrispNotificationClient.a(object, string3);
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            String string7 = CrispNotificationClient.b(object, string3) ? "[\u2026]\n" : "";
            notificationManagerCompat.notify(string3, 0, new NotificationCompat.Builder(object, string6).setSmallIcon(n2).setContentTitle((CharSequence)object2).setContentText((CharSequence)stringBuilder2.append(string7).append(string2).toString()).setWhen(l2).setShowWhen(true).setAutoCancel(true).setCategory("msg").setContentIntent(CrispNotificationClient.a(object, (TaskStackBuilder)object3, bl, string3, string4)).setColor(n3).setLights(n3, 500, 2000).setPriority(1).setVisibility(0).setSound(CrispNotificationClient.d(object)).setDefaults(-1).build());
            return;
        }
        Crisp.a(Logger.Level.WARN, "Crisp", "Notifications are disabled or permission is denied");
    }

    public static boolean openChatbox(@NonNull Context object, @NonNull Intent object2) {
        if (!CrispNotificationClient.isCrispIntent(object2)) {
            Crisp.a(Logger.Level.WARN, "Crisp", "Intent is not a Crisp one, abort chatbox opening...");
            return false;
        }
        CharSequence charSequence = object2.getStringExtra(d);
        object2 = object2.getStringExtra(e);
        boolean bl = Crisp.e().isAtLeast(Logger.Level.DEBUG);
        String string2 = charSequence != null && object2 != null ? (String)object2 + " (website: " + (String)charSequence + ") " : null;
        if (CrispNotificationClient.d(object, (String)charSequence, (String)object2)) {
            object2 = Logger.Level.INFO;
            charSequence = "Crisp";
            StringBuilder stringBuilder = new StringBuilder().append("Session ");
            if (!bl) {
                string2 = "";
            }
            Crisp.a((Logger.Level)((Object)object2), (String)charSequence, stringBuilder.append(string2).append("is current, opening chatbox...").toString());
            object.startActivity(new Intent(object, ChatActivity.class));
            return true;
        }
        if (CrispNotificationClient.e(object, (String)charSequence, (String)object2)) {
            object2 = Logger.Level.INFO;
            String string3 = "Crisp";
            StringBuilder stringBuilder = new StringBuilder().append("Session ");
            if (!bl) {
                string2 = "";
            }
            Object object3 = object;
            Crisp.a((Logger.Level)((Object)object2), string3, stringBuilder.append(string2).append("exists, switching website and opening chatbox...").toString());
            Crisp.configure(object3, (String)charSequence);
            object3.startActivity(new Intent(object, ChatActivity.class));
            return true;
        }
        object = Logger.Level.WARN;
        object2 = "Crisp";
        charSequence = new StringBuilder().append("Session ");
        if (!bl) {
            string2 = "";
        }
        Crisp.a((Logger.Level)((Object)object), (String)object2, ((StringBuilder)charSequence).append(string2).append("not found, abort chatbox opening...").toString());
        return false;
    }

    private static boolean b(@NonNull Context object, @NonNull String string2) {
        object = NotificationManagerCompat.from((Context)object).getActiveNotifications().iterator();
        while (object.hasNext()) {
            if (!string2.equals(((StatusBarNotification)object.next()).getTag())) continue;
            return true;
        }
        return false;
    }

    @DrawableRes
    private static int c(@NonNull Context context) {
        return (context = CrispNotificationClient.a(context)) != null ? context.getInt(h, R.drawable.crisp_sdk_notification_icon) : R.drawable.crisp_sdk_notification_icon;
    }

    private static int a(@NonNull Context context, @NonNull String string2) {
        Bundle bundle = CrispNotificationClient.a(context);
        int n2 = bundle != null ? bundle.getInt(i, 0) : 0;
        return n2 != 0 ? context.getResources().getColor(n2) : o.a.getThemeColor(context, string2).getRegular(context, string2);
    }

    @Nullable
    private static Bundle a(@NonNull Context context) {
        try {
            return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Nullable
    private static PendingIntent a(@NonNull Context context, @Nullable TaskStackBuilder taskStackBuilder, boolean bl, @Nullable String string2, @Nullable String string3) {
        if (taskStackBuilder == null) {
            taskStackBuilder = CrispNotificationClient.b(context);
        }
        if (taskStackBuilder != null) {
            if (bl) {
                taskStackBuilder.addNextIntent(CrispNotificationClient.b(context, string2, string3));
            } else {
                Intent intent;
                int n2 = taskStackBuilder.getIntentCount();
                if (n2 > 0 && (intent = taskStackBuilder.editIntentAt(n2 - 1)) != null) {
                    CrispNotificationClient.a(intent, string2, string3);
                }
            }
        }
        return taskStackBuilder != null ? taskStackBuilder.getPendingIntent(0, 0xC000000) : null;
    }

    @Nullable
    private static TaskStackBuilder b(@NonNull Context context) {
        Context context2 = context;
        TaskStackBuilder taskStackBuilder = TaskStackBuilder.create((Context)context2);
        context = context2.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (context != null) {
            TaskStackBuilder taskStackBuilder2 = taskStackBuilder;
            taskStackBuilder2.addNextIntent((Intent)context);
            return taskStackBuilder2;
        }
        return null;
    }

    @NonNull
    private static Intent b(@NonNull Context context, @Nullable String string2, @Nullable String string3) {
        Intent intent = new Intent(context, ChatActivity.class);
        intent.addFlags(0x24000000);
        CrispNotificationClient.a(intent, string2, string3);
        return intent;
    }

    private static void a(@NonNull Intent intent, @Nullable String string2, @Nullable String string3) {
        Intent intent2 = intent;
        intent2.putExtra(f, g);
        intent2.putExtra(d, string2);
        intent2.putExtra(e, string3);
    }

    private static Uri d(@NonNull Context context) {
        return Uri.parse((String)("android.resource://" + context.getApplicationContext().getPackageName() + "/" + im.crisp.client.internal.L.d.c(context, "crisp_chat_message_receive")));
    }

    public static interface b {
        public void a(@Nullable String var1);
    }

    public static enum a {
        NONE,
        ASKED,
        REPLIED;

    }
}

