/*
 * Decompiled with CFR 0.152.
 */
package im.crisp.client.external.data.message;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import im.crisp.client.external.Crisp;
import im.crisp.client.external.data.message.Preview;
import im.crisp.client.external.data.message.User;
import im.crisp.client.external.data.message.content.AnimationContent;
import im.crisp.client.external.data.message.content.AudioContent;
import im.crisp.client.external.data.message.content.CarouselContent;
import im.crisp.client.external.data.message.content.Content;
import im.crisp.client.external.data.message.content.FieldContent;
import im.crisp.client.external.data.message.content.FileContent;
import im.crisp.client.external.data.message.content.PickerContent;
import im.crisp.client.external.data.message.content.TextContent;
import im.crisp.client.internal.n.h;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Message {
    @SerializedName(value="website_id")
    @NonNull
    private final String websiteId;
    @SerializedName(value="session_id")
    @NonNull
    private final String sessionId;
    @SerializedName(value="fingerprint")
    private final long fingerprint;
    @SerializedName(value="type")
    @NonNull
    private final Type type;
    @SerializedName(value="from")
    @NonNull
    private final From from;
    @SerializedName(value="origin")
    @NonNull
    private final Origin origin;
    @SerializedName(value="content")
    @NonNull
    private final Content content;
    @SerializedName(value="preview")
    @Nullable
    private final List<Preview> preview;
    @SerializedName(value="read")
    private final boolean read;
    @SerializedName(value="timestamp")
    private final long timestamp;
    @SerializedName(value="user")
    @NonNull
    private final User user;

    private Message(@NonNull Builder builder) {
        this.websiteId = builder.websiteId;
        this.sessionId = builder.sessionId;
        this.fingerprint = builder.fingerprint;
        this.type = builder.type;
        this.from = builder.from;
        this.origin = builder.origin;
        this.content = builder.content;
        this.preview = builder.preview;
        this.read = builder.read;
        this.timestamp = builder.timestamp;
        this.user = builder.user;
    }

    @NonNull
    public String getWebsiteId() {
        return this.websiteId;
    }

    @NonNull
    public String getSessionId() {
        return this.sessionId;
    }

    public long getFingerprint() {
        return this.fingerprint;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public From getFrom() {
        return this.from;
    }

    public boolean isMe() {
        return this.from == From.USER;
    }

    @NonNull
    public Origin getOrigin() {
        return this.origin;
    }

    @NonNull
    public Content getContent() {
        return this.content;
    }

    @Nullable
    public List<Preview> getPreview() {
        return this.preview;
    }

    public boolean isRead() {
        return this.read;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public User getUser() {
        return this.user;
    }

    @NonNull
    public String toJSON() {
        return h.a().toJson((Object)this);
    }

    public static final class Builder {
        @NonNull
        private final String websiteId;
        @NonNull
        private final String sessionId;
        private final long fingerprint;
        @NonNull
        private final Type type;
        @NonNull
        private final From from;
        @NonNull
        private final Origin origin;
        @NonNull
        private final Content content;
        private final long timestamp;
        @NonNull
        private final User user;
        @Nullable
        private List<Preview> preview;
        private boolean read;

        public Builder(@NonNull String string2, @NonNull String string3, long l2, @NonNull From from, @NonNull Origin origin, @NonNull Content content, long l3, @NonNull User user) throws IllegalArgumentException {
            Class<?> clazz = content.getClass();
            Type type = Type.TO_TYPE.get(clazz);
            if (type != null) {
                Builder builder = this;
                builder.websiteId = string2;
                builder.sessionId = string3;
                builder.fingerprint = l2;
                builder.from = from;
                builder.origin = origin;
                builder.content = content;
                builder.type = type;
                builder.timestamp = l3;
                builder.user = user;
                return;
            }
            throw new IllegalArgumentException("Unsupported content " + clazz.getSimpleName() + " class");
        }

        public Builder setPreview(@Nullable List<Preview> list) {
            this.preview = list;
            return this;
        }

        public Builder setRead(boolean bl) {
            this.read = bl;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static final class Type
    extends Enum<Type> {
        @SerializedName(value="text")
        public static final /* enum */ Type TEXT;
        @SerializedName(value="file")
        public static final /* enum */ Type FILE;
        @SerializedName(value="animation")
        public static final /* enum */ Type ANIMATION;
        @SerializedName(value="audio")
        public static final /* enum */ Type AUDIO;
        @SerializedName(value="picker")
        public static final /* enum */ Type PICKER;
        @SerializedName(value="field")
        public static final /* enum */ Type FIELD;
        @SerializedName(value="carousel")
        public static final /* enum */ Type CAROUSEL;
        private static final Map<Class<? extends Content>, Type> TO_TYPE;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string2) {
            return Enum.valueOf(Type.class, string2);
        }

        private static /* synthetic */ Type[] $values() {
            return new Type[]{TEXT, FILE, ANIMATION, AUDIO, PICKER, FIELD, CAROUSEL};
        }

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            Type type5;
            Type type6;
            Type type7;
            Type type8 = type7;
            TEXT = new Type();
            Type type9 = type6;
            FILE = new Type();
            Type type10 = type5;
            ANIMATION = new Type();
            Type type11 = type4;
            AUDIO = new Type();
            Type type12 = type3;
            PICKER = new Type();
            Type type13 = type2;
            FIELD = new Type();
            Type type14 = type;
            CAROUSEL = new Type();
            $VALUES = Type.$values();
            TO_TYPE = new HashMap<Class<? extends Content>, Type>();
            TO_TYPE.put(TextContent.class, type8);
            TO_TYPE.put(FileContent.class, type9);
            TO_TYPE.put(AnimationContent.class, type10);
            TO_TYPE.put(AudioContent.class, type11);
            TO_TYPE.put(PickerContent.class, type12);
            TO_TYPE.put(FieldContent.class, type13);
            TO_TYPE.put(CarouselContent.class, type14);
        }
    }

    public static enum From {
        USER,
        OPERATOR;

    }

    public static final class Origin {
        @NonNull
        private Type type;
        @NonNull
        private final String value;

        private Origin(@NonNull String string2) throws IllegalArgumentException {
            if (string2.startsWith("urn:")) {
                this.type = Type.URN;
            } else {
                for (Type type : Type.values()) {
                    if (type == Type.URN || !string2.equals(type.getValue())) continue;
                    this.type = type;
                    break;
                }
            }
            if (this.type != null) {
                this.value = string2;
                return;
            }
            throw new IllegalArgumentException("Expected one of chat, email or urn:* origin,  received " + string2 + " instead.");
        }

        private Origin(@NonNull Type type) throws IllegalArgumentException {
            if (type != Type.URN) {
                this.type = type;
                this.value = type.getValue();
                return;
            }
            throw new IllegalArgumentException("Expected one of chat, email or urn:* origin,  received " + (Object)((Object)type) + " instead.");
        }

        @Nullable
        public static Origin fromString(@NonNull String string2) {
            try {
                return new Origin(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Crisp.a("Crisp", illegalArgumentException);
                return null;
            }
        }

        @Nullable
        public static Origin fromType(@NonNull Type type) {
            try {
                return new Origin(type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Crisp.a("Crisp", illegalArgumentException);
                return null;
            }
        }

        @NonNull
        public String getValue() {
            return this.value;
        }

        public static enum Type {
            CHAT("chat"),
            EMAIL("email"),
            URN("urn"),
            DIFF("diff"),
            HISTORY("history"),
            LOCAL("local"),
            NETWORK("network"),
            UPDATE("update");

            @NonNull
            private final String value;

            private Type(String string3) {
                this.value = string3;
            }

            @NonNull
            private String getValue() {
                return this.value;
            }
        }
    }
}

