/*
 * Decompiled with CFR 0.152.
 */
package im.crisp.client.external;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import okhttp3.logging.HttpLoggingInterceptor;

public interface Logger {
    public void log(@Nullable String var1, @NonNull Throwable var2);

    public void log(@NonNull Level var1, @Nullable String var2, @NonNull String var3);

    public static enum Level {
        ASSERT(7),
        ERROR(6),
        WARN(5),
        INFO(4),
        DEBUG(3),
        VERBOSE(2);

        private final int level;

        private Level(int n3) {
            this.level = n3;
        }

        @Nullable
        public static Level fromJavaLevel(@NonNull java.util.logging.Level level) {
            int n2 = level.intValue();
            if (n2 == Integer.MAX_VALUE) {
                return null;
            }
            if (n2 >= 1000) {
                return ERROR;
            }
            if (n2 >= 900) {
                return WARN;
            }
            if (n2 >= 800) {
                return INFO;
            }
            if (n2 > Integer.MIN_VALUE) {
                return DEBUG;
            }
            return VERBOSE;
        }

        public final int getLevel() {
            return this.level;
        }

        public final boolean isAtLeast(@NonNull Level level) {
            return this.getLevel() <= level.getLevel();
        }

        @NonNull
        public String toString() {
            switch (a.a[this.ordinal()]) {
                default: {
                    return "WARN";
                }
                case 5: {
                    return "VERBOSE";
                }
                case 4: {
                    return "DEBUG";
                }
                case 3: {
                    return "INFO";
                }
                case 2: {
                    return "ERROR";
                }
                case 1: 
            }
            return "ASSERT";
        }

        @NonNull
        public final java.util.logging.Level toJavaLevel() {
            switch (a.a[this.ordinal()]) {
                default: {
                    return java.util.logging.Level.WARNING;
                }
                case 5: {
                    return java.util.logging.Level.ALL;
                }
                case 4: {
                    return java.util.logging.Level.FINEST;
                }
                case 3: {
                    return java.util.logging.Level.INFO;
                }
                case 1: 
                case 2: 
            }
            return java.util.logging.Level.SEVERE;
        }

        @NonNull
        public final HttpLoggingInterceptor.Level toHttpLevel() {
            int n2 = a.a[this.ordinal()];
            if (n2 != 3) {
                if (n2 != 4 && n2 != 5) {
                    return HttpLoggingInterceptor.Level.NONE;
                }
                return HttpLoggingInterceptor.Level.BODY;
            }
            return HttpLoggingInterceptor.Level.BASIC;
        }
    }
}

