/*
 * Decompiled with CFR 0.152.
 */
package im.amomo.loading.indicator;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import im.amomo.loading.indicator.BaseIndicatorController;
import java.util.ArrayList;
import java.util.List;

public class BallGridBeatIndicator
extends BaseIndicatorController {
    public static final int ALPHA = 255;
    int[] alphas = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float circleSpacing = 4.0f;
        float radius = ((float)this.getWidth() - circleSpacing * 4.0f) / 6.0f;
        float x = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        float y = (float)(this.getWidth() / 2) - (radius * 2.0f + circleSpacing);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                canvas.save();
                float translateX = x + radius * 2.0f * (float)j + circleSpacing * (float)j;
                float translateY = y + radius * 2.0f * (float)i + circleSpacing * (float)i;
                canvas.translate(translateX, translateY);
                paint.setAlpha(this.alphas[3 * i + j]);
                canvas.drawCircle(0.0f, 0.0f, radius, paint);
                canvas.restore();
            }
        }
    }

    @Override
    public List<Animator> createAnimation() {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        int[] durations = new int[]{960, 930, 1190, 1130, 1340, 940, 1200, 820, 1190};
        int[] delays = new int[]{360, 400, 680, 410, 710, -150, -120, 10, 320};
        for (int i = 0; i < 9; ++i) {
            final int index = i;
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 168, 255});
            alphaAnim.setDuration((long)durations[i]);
            alphaAnim.setRepeatCount(-1);
            alphaAnim.setStartDelay((long)delays[i]);
            alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallGridBeatIndicator.this.alphas[index] = (Integer)animation.getAnimatedValue();
                    BallGridBeatIndicator.this.postInvalidate();
                }
            });
            alphaAnim.start();
            animators.add((Animator)alphaAnim);
        }
        return animators;
    }
}

