/*
 * Decompiled with CFR 0.152.
 */
package im.amomo.loading;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import im.amomo.loading.R;
import im.amomo.loading.indicator.BallBeatIndicator;
import im.amomo.loading.indicator.BallClipRotateIndicator;
import im.amomo.loading.indicator.BallClipRotateMultipleIndicator;
import im.amomo.loading.indicator.BallClipRotatePulseIndicator;
import im.amomo.loading.indicator.BallGridBeatIndicator;
import im.amomo.loading.indicator.BallGridPulseIndicator;
import im.amomo.loading.indicator.BallPulseIndicator;
import im.amomo.loading.indicator.BallPulseRiseIndicator;
import im.amomo.loading.indicator.BallPulseSyncIndicator;
import im.amomo.loading.indicator.BallRotateIndicator;
import im.amomo.loading.indicator.BallScaleIndicator;
import im.amomo.loading.indicator.BallScaleMultipleIndicator;
import im.amomo.loading.indicator.BallScaleRippleIndicator;
import im.amomo.loading.indicator.BallScaleRippleMultipleIndicator;
import im.amomo.loading.indicator.BallSpinFadeLoaderIndicator;
import im.amomo.loading.indicator.BallTrianglePathIndicator;
import im.amomo.loading.indicator.BallZigZagDeflectIndicator;
import im.amomo.loading.indicator.BallZigZagIndicator;
import im.amomo.loading.indicator.BaseIndicatorController;
import im.amomo.loading.indicator.CubeTransitionIndicator;
import im.amomo.loading.indicator.LineScaleIndicator;
import im.amomo.loading.indicator.LineScalePartyIndicator;
import im.amomo.loading.indicator.LineScalePulseOutIndicator;
import im.amomo.loading.indicator.LineScalePulseOutRapidIndicator;
import im.amomo.loading.indicator.LineSpinFadeLoaderIndicator;
import im.amomo.loading.indicator.PacmanIndicator;
import im.amomo.loading.indicator.SemiCircleSpinIndicator;
import im.amomo.loading.indicator.SquareSpinIndicator;
import im.amomo.loading.indicator.TriangleSkewSpinIndicator;

public class LoadingIndicatorView
extends View {
    public static final int BallPulse = 0;
    public static final int BallGridPulse = 1;
    public static final int BallClipRotate = 2;
    public static final int BallClipRotatePulse = 3;
    public static final int SquareSpin = 4;
    public static final int BallClipRotateMultiple = 5;
    public static final int BallPulseRise = 6;
    public static final int BallRotate = 7;
    public static final int CubeTransition = 8;
    public static final int BallZigZag = 9;
    public static final int BallZigZagDeflect = 10;
    public static final int BallTrianglePath = 11;
    public static final int BallScale = 12;
    public static final int LineScale = 13;
    public static final int LineScaleParty = 14;
    public static final int BallScaleMultiple = 15;
    public static final int BallPulseSync = 16;
    public static final int BallBeat = 17;
    public static final int LineScalePulseOut = 18;
    public static final int LineScalePulseOutRapid = 19;
    public static final int BallScaleRipple = 20;
    public static final int BallScaleRippleMultiple = 21;
    public static final int BallSpinFadeLoader = 22;
    public static final int LineSpinFadeLoader = 23;
    public static final int TriangleSkewSpin = 24;
    public static final int Pacman = 25;
    public static final int BallGridBeat = 26;
    public static final int SemiCircleSpin = 27;
    public static final int DEFAULT_SIZE = 45;
    int mIndicatorId;
    int mIndicatorColor;
    Paint mPaint;
    BaseIndicatorController mIndicatorController;
    private boolean mHasAnimation;

    public LoadingIndicatorView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public LoadingIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public LoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public LoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.LoadingIndicatorView);
        this.mIndicatorId = a.getInt(R.styleable.LoadingIndicatorView_indicator, 0);
        this.mIndicatorColor = a.getColor(R.styleable.LoadingIndicatorView_indicator_color, -1);
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mIndicatorColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.applyIndicator();
    }

    private void applyIndicator() {
        switch (this.mIndicatorId) {
            case 0: {
                this.mIndicatorController = new BallPulseIndicator();
                break;
            }
            case 1: {
                this.mIndicatorController = new BallGridPulseIndicator();
                break;
            }
            case 2: {
                this.mIndicatorController = new BallClipRotateIndicator();
                break;
            }
            case 3: {
                this.mIndicatorController = new BallClipRotatePulseIndicator();
                break;
            }
            case 4: {
                this.mIndicatorController = new SquareSpinIndicator();
                break;
            }
            case 5: {
                this.mIndicatorController = new BallClipRotateMultipleIndicator();
                break;
            }
            case 6: {
                this.mIndicatorController = new BallPulseRiseIndicator();
                break;
            }
            case 7: {
                this.mIndicatorController = new BallRotateIndicator();
                break;
            }
            case 8: {
                this.mIndicatorController = new CubeTransitionIndicator();
                break;
            }
            case 9: {
                this.mIndicatorController = new BallZigZagIndicator();
                break;
            }
            case 10: {
                this.mIndicatorController = new BallZigZagDeflectIndicator();
                break;
            }
            case 11: {
                this.mIndicatorController = new BallTrianglePathIndicator();
                break;
            }
            case 12: {
                this.mIndicatorController = new BallScaleIndicator();
                break;
            }
            case 13: {
                this.mIndicatorController = new LineScaleIndicator();
                break;
            }
            case 14: {
                this.mIndicatorController = new LineScalePartyIndicator();
                break;
            }
            case 15: {
                this.mIndicatorController = new BallScaleMultipleIndicator();
                break;
            }
            case 16: {
                this.mIndicatorController = new BallPulseSyncIndicator();
                break;
            }
            case 17: {
                this.mIndicatorController = new BallBeatIndicator();
                break;
            }
            case 18: {
                this.mIndicatorController = new LineScalePulseOutIndicator();
                break;
            }
            case 19: {
                this.mIndicatorController = new LineScalePulseOutRapidIndicator();
                break;
            }
            case 20: {
                this.mIndicatorController = new BallScaleRippleIndicator();
                break;
            }
            case 21: {
                this.mIndicatorController = new BallScaleRippleMultipleIndicator();
                break;
            }
            case 22: {
                this.mIndicatorController = new BallSpinFadeLoaderIndicator();
                break;
            }
            case 23: {
                this.mIndicatorController = new LineSpinFadeLoaderIndicator();
                break;
            }
            case 24: {
                this.mIndicatorController = new TriangleSkewSpinIndicator();
                break;
            }
            case 25: {
                this.mIndicatorController = new PacmanIndicator();
                break;
            }
            case 26: {
                this.mIndicatorController = new BallGridBeatIndicator();
                break;
            }
            case 27: {
                this.mIndicatorController = new SemiCircleSpinIndicator();
            }
        }
        this.mIndicatorController.setTarget(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(this.dp2px(45), widthMeasureSpec);
        int height = this.measureDimension(this.dp2px(45), heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureDimension(int defaultSize, int measureSpec) {
        int result = defaultSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(defaultSize, specSize) : defaultSize);
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawIndicator(canvas);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mHasAnimation) {
            this.mHasAnimation = true;
            this.applyAnimation();
        }
    }

    public void setVisibility(int v) {
        if (this.getVisibility() != v) {
            super.setVisibility(v);
            if (v == 8 || v == 4) {
                this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.END);
            } else {
                this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.START);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mHasAnimation) {
            this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.START);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIndicatorController.setAnimationStatus(BaseIndicatorController.AnimStatus.CANCEL);
    }

    void drawIndicator(Canvas canvas) {
        this.mIndicatorController.draw(canvas, this.mPaint);
    }

    void applyAnimation() {
        this.mIndicatorController.initAnimation();
    }

    private int dp2px(int dpValue) {
        return (int)this.getContext().getResources().getDisplayMetrics().density * dpValue;
    }

    public static @interface Indicator {
    }
}

