/*
 * Decompiled with CFR 0.152.
 */
package com.igalg.jenkins.plugins.mswt;

import com.google.common.annotations.VisibleForTesting;
import com.igalg.jenkins.plugins.mswt.locator.ComputedFolderWebHookTriggerLocator;
import com.igalg.jenkins.plugins.mswt.locator.JenkinsInstanceComputedFolderLocator;
import com.igalg.jenkins.plugins.mswt.locator.LocatedComputedFolder;
import com.igalg.jenkins.plugins.mswt.trigger.ComputedFolderWebHookTrigger;
import com.igalg.jenkins.plugins.mswt.trigger.ComputedFolderWebHookTriggerResult;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class ComputedFolderWebHookRequestReceiver
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final String NO_JOBS_MSG = "Did not find any jobs with multibranch scan webhook trigger configured.you need to pass token like ...multibranch-webhook-trigger/invoke?token=TOKENHERE. ";
    private static final String URL_NAME = "multibranch-webhook-trigger";
    private static final String TOKEN_PARAM = "token";
    private static final Logger LOGGER = Logger.getLogger(ComputedFolderWebHookRequestReceiver.class.getName());

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/multibranch-webhook-trigger/")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    public HttpResponse doInvoke(StaplerRequest request) {
        Map parameterMap = null;
        Map<String, List<String>> headers = null;
        headers = this.getHeaders(request);
        parameterMap = request.getParameterMap();
        String givenToken = this.getGivenToken(headers, parameterMap);
        return this.doInvoke(givenToken);
    }

    @VisibleForTesting
    String getGivenToken(Map<String, List<String>> headers, Map<String, String[]> parameterMap) {
        if (parameterMap.containsKey(TOKEN_PARAM)) {
            return parameterMap.get(TOKEN_PARAM)[0];
        }
        if (headers.containsKey(TOKEN_PARAM)) {
            return headers.get(TOKEN_PARAM).get(0);
        }
        return null;
    }

    @VisibleForTesting
    Map<String, List<String>> getHeaders(StaplerRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration headersEnumeration = request.getHeaderNames();
        while (headersEnumeration.hasMoreElements()) {
            String headerName = (String)headersEnumeration.nextElement();
            headers.put(headerName.toLowerCase(), Collections.list(request.getHeaders(headerName)));
        }
        return headers;
    }

    @VisibleForTesting
    HttpResponse doInvoke(String givenToken) {
        JenkinsInstanceComputedFolderLocator computedFolderLocator = new JenkinsInstanceComputedFolderLocator();
        List<LocatedComputedFolder> locatedList = ComputedFolderWebHookTriggerLocator.locateJobsWithTrigger(computedFolderLocator, givenToken);
        HashMap<String, Object> triggerResultsMap = new HashMap<String, Object>();
        if (locatedList.isEmpty()) {
            LOGGER.log(Level.INFO, NO_JOBS_MSG);
            triggerResultsMap.put("ANY", NO_JOBS_MSG);
        }
        for (LocatedComputedFolder locatedComputedFolder : locatedList) {
            try {
                LOGGER.log(Level.INFO, "Triggering " + locatedComputedFolder.getFullName());
                ComputedFolderWebHookTrigger trigger = locatedComputedFolder.getTrigger();
                ComputedFolderWebHookTriggerResult triggerResults = trigger.trigger();
                triggerResultsMap.put(locatedComputedFolder.getFullName(), triggerResults);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, locatedComputedFolder.getFullName(), t);
                String msg = "Exception occurred, full stack trace in Jenkins server log. Thrown in: " + t.getStackTrace()[0].getClassName() + ":" + t.getStackTrace()[0].getLineNumber();
                triggerResultsMap.put(locatedComputedFolder.getFullName(), msg);
            }
        }
        HashMap<String, HashMap<String, Object>> response = new HashMap<String, HashMap<String, Object>>();
        response.put("triggerResults", triggerResultsMap);
        return HttpResponses.okJSON(response);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }
}

