/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.utils;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import id.vouched.android.TFLiteObjectDetectionAPIModel;
import id.vouched.android.env.ImageUtils;
import id.vouched.android.exception.VouchedAssetsMissingException;
import id.vouched.android.tflite.Classifier;
import java.util.Collection;
import java.util.List;
import java9.util.stream.Collectors;
import java9.util.stream.StreamSupport;

public class IdClassifierUtils {
    private static final int TF_OD_API_INPUT_SIZE = 320;
    private static final boolean TF_OD_API_IS_QUANTIZED = false;
    private static final String TF_OD_API_MODEL_FILE = "inference_graph.tflite";
    private static final String TF_OD_API_LABELS_FILE = "file:///android_asset/labelmap_mobilenet_card.txt";
    private static Classifier classifierInstance;
    private static final Object objectForSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Classifier getClassifierInstance(AssetManager assetManager) throws VouchedAssetsMissingException {
        if (classifierInstance != null) {
            return classifierInstance;
        }
        Object object = objectForSync;
        synchronized (object) {
            if (classifierInstance == null) {
                classifierInstance = TFLiteObjectDetectionAPIModel.create(assetManager, TF_OD_API_MODEL_FILE, TF_OD_API_LABELS_FILE, 320, false);
            }
            return classifierInstance;
        }
    }

    public static List<Classifier.Recognition> detectIds(@NonNull Bitmap photo, AssetManager assetManager) throws VouchedAssetsMissingException {
        Classifier classifier = IdClassifierUtils.getClassifierInstance(assetManager);
        Bitmap bitmapToClassify = Bitmap.createBitmap((int)320, (int)320, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Matrix transformationMatrix = ImageUtils.getTransformationMatrix(photo.getWidth(), photo.getHeight(), 320, 320, 0, false);
        Canvas canvas = new Canvas(bitmapToClassify);
        canvas.drawBitmap(photo, transformationMatrix, null);
        List<Classifier.Recognition> results = classifier.recognizeImage(bitmapToClassify);
        List cardResults = (List)StreamSupport.stream(results).filter(r -> r.getConfidence().floatValue() > 0.7f).collect(Collectors.toList());
        bitmapToClassify.recycle();
        Matrix invertedTransformationMatrix = new Matrix();
        transformationMatrix.invert(invertedTransformationMatrix);
        StreamSupport.stream((Collection)cardResults).forEach(r -> {
            RectF location = r.getLocation();
            invertedTransformationMatrix.mapRect(location);
            r.setLocation(location);
        });
        return cardResults;
    }

    static {
        objectForSync = new Object();
    }
}

