/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.utils;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.util.Base64;
import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private BitmapUtils() {
    }

    public static String toBase64(Bitmap bitmap, Bitmap.CompressFormat compressFormat, int quality, int base64Flags) {
        if (bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            bitmap.compress(compressFormat, quality, (OutputStream)os);
            byte[] imageArr = os.toByteArray();
            return Base64.encodeToString((byte[])imageArr, (int)base64Flags);
        }
        return "";
    }

    public static String toBase64(Bitmap bitmap) {
        return BitmapUtils.toBase64(bitmap, Bitmap.CompressFormat.JPEG, 100, 2);
    }

    public static Bitmap downsizeIfNeeded(Bitmap bitmap, int maxSize) {
        int h;
        if (bitmap == null || bitmap.getWidth() == 0 || bitmap.getHeight() == 0) {
            return null;
        }
        int w = bitmap.getWidth();
        int currentSize = w * (h = bitmap.getHeight());
        if (currentSize <= maxSize) {
            return bitmap;
        }
        double scale = Math.sqrt((double)maxSize / (double)currentSize);
        int scaledWidth = (int)((double)w * scale);
        int scaledHeight = (int)((double)h * scale);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)scaledWidth, (int)scaledHeight, (boolean)true);
    }

    public static Bitmap clippingBitmap(@NonNull RectF location, @NonNull Bitmap bitmapSource) {
        location = new RectF(location);
        location.top = location.top < 0.0f ? 0.0f : location.top;
        location.left = location.left < 0.0f ? 0.0f : location.left;
        location.right = location.right < 0.0f ? 0.0f : location.right;
        float f = location.bottom = location.bottom < 0.0f ? 0.0f : location.bottom;
        if (location.left + location.width() > (float)bitmapSource.getWidth()) {
            location.left = 0.0f;
            location.right = bitmapSource.getWidth();
        }
        if (location.top + location.height() > (float)bitmapSource.getHeight()) {
            location.top = 0.0f;
            location.bottom = bitmapSource.getHeight();
        }
        return Bitmap.createBitmap((Bitmap)bitmapSource, (int)((int)Math.floor(location.left)), (int)((int)Math.floor(location.top)), (int)((int)Math.floor(location.width())), (int)((int)Math.floor(location.height())));
    }
}

