/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.tracking;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import id.vouched.android.VouchedLogger;
import id.vouched.android.env.BorderedText;
import id.vouched.android.env.ImageUtils;
import id.vouched.android.tflite.Classifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class MultiBoxTracker {
    private static final float TEXT_SIZE_DIP = 18.0f;
    private static final float MIN_SIZE = 16.0f;
    private static final int[] COLORS = new int[]{-16776961};
    final List<Pair<Float, RectF>> screenRects = new LinkedList<Pair<Float, RectF>>();
    private final Queue<Integer> availableColors = new LinkedList<Integer>();
    private final List<TrackedRecognition> trackedObjects = new LinkedList<TrackedRecognition>();
    private final Paint boxPaint = new Paint();
    private final float textSizePx;
    private final BorderedText borderedText;
    private Matrix frameToCanvasMatrix;
    private int frameWidth;
    private int frameHeight;
    private int sensorOrientation;

    public MultiBoxTracker(Context context) {
        for (int color : COLORS) {
            this.availableColors.add(color);
        }
        this.boxPaint.setColor(-65536);
        this.boxPaint.setStyle(Paint.Style.STROKE);
        this.boxPaint.setStrokeWidth(10.0f);
        this.boxPaint.setStrokeCap(Paint.Cap.ROUND);
        this.boxPaint.setStrokeJoin(Paint.Join.ROUND);
        this.boxPaint.setStrokeMiter(100.0f);
        this.textSizePx = TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.borderedText = new BorderedText(this.textSizePx);
    }

    public synchronized void setFrameConfiguration(int width, int height, int sensorOrientation) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.sensorOrientation = sensorOrientation;
    }

    public synchronized void drawDebug(Canvas canvas) {
        Paint textPaint = new Paint();
        textPaint.setColor(-1);
        textPaint.setTextSize(60.0f);
        Paint boxPaint = new Paint();
        boxPaint.setColor(-65536);
        boxPaint.setAlpha(200);
        boxPaint.setStyle(Paint.Style.STROKE);
        for (Pair<Float, RectF> detection : this.screenRects) {
            RectF rect = (RectF)detection.second;
            canvas.drawRect(rect, boxPaint);
            canvas.drawText("" + detection.first, rect.left, rect.top, textPaint);
            this.borderedText.drawText(canvas, rect.centerX(), rect.centerY(), "" + detection.first);
        }
    }

    public synchronized void trackResults(List<Classifier.Recognition> results, long timestamp) {
        VouchedLogger.getInstance().debug("Processing" + results.size() + " results from " + timestamp);
        this.processResults(results);
    }

    private Matrix getFrameToCanvasMatrix() {
        return this.frameToCanvasMatrix;
    }

    public synchronized void draw(Canvas canvas) {
        boolean rotated = this.sensorOrientation % 180 == 90;
        float multiplier = Math.min((float)canvas.getHeight() / (float)(rotated ? this.frameWidth : this.frameHeight), (float)canvas.getWidth() / (float)(rotated ? this.frameHeight : this.frameWidth));
        this.frameToCanvasMatrix = ImageUtils.getTransformationMatrix(this.frameWidth, this.frameHeight, (int)(multiplier * (float)(rotated ? this.frameHeight : this.frameWidth)), (int)(multiplier * (float)(rotated ? this.frameWidth : this.frameHeight)), this.sensorOrientation, false);
        for (TrackedRecognition recognition : this.trackedObjects) {
            RectF trackedPos = new RectF(recognition.location);
            this.getFrameToCanvasMatrix().mapRect(trackedPos);
            this.boxPaint.setColor(recognition.color);
            float cornerSize = Math.min(trackedPos.width(), trackedPos.height()) / 8.0f;
            canvas.drawRoundRect(trackedPos, cornerSize, cornerSize, this.boxPaint);
            String labelString = !TextUtils.isEmpty((CharSequence)recognition.title) ? String.format("%s %.2f", recognition.title, Float.valueOf(100.0f * recognition.detectionConfidence)) : String.format("%.2f", Float.valueOf(100.0f * recognition.detectionConfidence));
            this.borderedText.drawText(canvas, trackedPos.left + cornerSize, trackedPos.top, labelString + "%", this.boxPaint);
        }
    }

    private void processResults(List<Classifier.Recognition> results) {
        LinkedList<Pair> rectsToTrack = new LinkedList<Pair>();
        this.screenRects.clear();
        Matrix rgbFrameToScreen = new Matrix(this.getFrameToCanvasMatrix());
        for (Classifier.Recognition result : results) {
            if (result.getLocation() == null) continue;
            RectF detectionFrameRect = new RectF(result.getLocation());
            RectF detectionScreenRect = new RectF();
            rgbFrameToScreen.mapRect(detectionScreenRect, detectionFrameRect);
            VouchedLogger.getInstance().debug("Result! Frame: " + result.getLocation() + " mapped to screen:" + detectionScreenRect);
            this.screenRects.add((Pair<Float, RectF>)new Pair((Object)result.getConfidence(), (Object)detectionScreenRect));
            if (detectionFrameRect.width() < 16.0f || detectionFrameRect.height() < 16.0f) {
                VouchedLogger.getInstance().debug("Degenerate rectangle! " + detectionFrameRect);
                continue;
            }
            rectsToTrack.add(new Pair((Object)result.getConfidence(), (Object)result));
        }
        this.trackedObjects.clear();
        if (rectsToTrack.isEmpty()) {
            VouchedLogger.getInstance().debug("Nothing to track, aborting.");
            return;
        }
        for (Pair potential : rectsToTrack) {
            TrackedRecognition trackedRecognition = new TrackedRecognition();
            trackedRecognition.detectionConfidence = ((Float)potential.first).floatValue();
            trackedRecognition.location = new RectF(((Classifier.Recognition)potential.second).getLocation());
            trackedRecognition.title = ((Classifier.Recognition)potential.second).getTitle();
            trackedRecognition.color = COLORS[this.trackedObjects.size()];
            this.trackedObjects.add(trackedRecognition);
            if (this.trackedObjects.size() < COLORS.length) continue;
            break;
        }
    }

    private static class TrackedRecognition {
        RectF location;
        float detectionConfidence;
        int color;
        String title;

        private TrackedRecognition() {
        }
    }
}

