/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.mlkit;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.Image;
import android.os.SystemClock;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageProxy;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.mlkit.vision.common.InputImage;
import id.vouched.android.mlkit.BitmapUtils;
import id.vouched.android.mlkit.FrameMetadata;
import id.vouched.android.mlkit.GraphicOverlay;
import id.vouched.android.mlkit.ScopedExecutor;
import id.vouched.android.mlkit.VisionImageProcessor;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;

public abstract class VisionProcessorBase<T>
implements VisionImageProcessor {
    protected static final String MANUAL_TESTING_LOG = "LogTagForTest";
    private static final String TAG = "VisionProcessorBase";
    private final ActivityManager activityManager;
    private final Timer fpsTimer = new Timer();
    private final ScopedExecutor executor;
    private boolean isShutdown;
    private int numRuns = 0;
    private long totalFrameMs = 0L;
    private long maxFrameMs = 0L;
    private long minFrameMs = Long.MAX_VALUE;
    private long totalDetectorMs = 0L;
    private long maxDetectorMs = 0L;
    private long minDetectorMs = Long.MAX_VALUE;
    private int frameProcessedInOneSecondInterval = 0;
    private int framesPerSecond = 0;
    @GuardedBy(value="this")
    private ByteBuffer latestImage;
    @GuardedBy(value="this")
    private FrameMetadata latestImageMetaData;
    @GuardedBy(value="this")
    private ByteBuffer processingImage;
    @GuardedBy(value="this")
    private FrameMetadata processingMetaData;

    protected VisionProcessorBase(Context context) {
        this.activityManager = (ActivityManager)context.getSystemService("activity");
        this.executor = new ScopedExecutor(TaskExecutors.MAIN_THREAD);
        this.fpsTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                VisionProcessorBase.this.framesPerSecond = VisionProcessorBase.this.frameProcessedInOneSecondInterval;
                VisionProcessorBase.this.frameProcessedInOneSecondInterval = 0;
            }
        }, 0L, 1000L);
    }

    @Override
    public void processBitmap(Bitmap bitmap, GraphicOverlay graphicOverlay) {
        long frameStartMs = SystemClock.elapsedRealtime();
        this.requestDetectInImage(InputImage.fromBitmap((Bitmap)bitmap, (int)0), graphicOverlay, null, false, frameStartMs);
    }

    @Override
    public synchronized void processByteBuffer(ByteBuffer data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay) {
        this.latestImage = data;
        this.latestImageMetaData = frameMetadata;
        if (this.processingImage == null && this.processingMetaData == null) {
            this.processLatestImage(graphicOverlay);
        }
    }

    private synchronized void processLatestImage(GraphicOverlay graphicOverlay) {
        this.processingImage = this.latestImage;
        this.processingMetaData = this.latestImageMetaData;
        this.latestImage = null;
        this.latestImageMetaData = null;
        if (this.processingImage != null && this.processingMetaData != null && !this.isShutdown) {
            this.processImage(this.processingImage, this.processingMetaData, graphicOverlay);
        }
    }

    private void processImage(ByteBuffer data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay) {
        long frameStartMs = SystemClock.elapsedRealtime();
        Bitmap bitmap = BitmapUtils.getBitmap(data, frameMetadata);
        this.requestDetectInImage(InputImage.fromByteBuffer((ByteBuffer)data, (int)frameMetadata.getWidth(), (int)frameMetadata.getHeight(), (int)frameMetadata.getRotation(), (int)17), graphicOverlay, bitmap, true, frameStartMs).addOnSuccessListener((Executor)this.executor, results -> this.processLatestImage(graphicOverlay));
    }

    @Override
    @RequiresApi(value=19)
    @ExperimentalGetImage
    public void processImageProxy(ImageProxy image, GraphicOverlay graphicOverlay) {
        long frameStartMs = SystemClock.elapsedRealtime();
        if (this.isShutdown) {
            image.close();
            return;
        }
        Bitmap bitmap = null;
        bitmap = BitmapUtils.getBitmap(image);
        this.requestDetectInImage(InputImage.fromMediaImage((Image)image.getImage(), (int)image.getImageInfo().getRotationDegrees()), graphicOverlay, bitmap, true, frameStartMs).addOnCompleteListener(results -> image.close());
    }

    private Task<T> requestDetectInImage(InputImage image, GraphicOverlay graphicOverlay, @Nullable Bitmap originalCameraImage, boolean shouldShowFps, long frameStartMs) {
        long detectorStartMs = SystemClock.elapsedRealtime();
        return this.detectInImage(image).addOnSuccessListener((Executor)this.executor, results -> {
            long endMs = SystemClock.elapsedRealtime();
            long currentFrameLatencyMs = endMs - frameStartMs;
            long currentDetectorLatencyMs = endMs - detectorStartMs;
            ++this.numRuns;
            ++this.frameProcessedInOneSecondInterval;
            this.totalFrameMs += currentFrameLatencyMs;
            this.maxFrameMs = Math.max(currentFrameLatencyMs, this.maxFrameMs);
            this.minFrameMs = Math.min(currentFrameLatencyMs, this.minFrameMs);
            this.totalDetectorMs += currentDetectorLatencyMs;
            this.maxDetectorMs = Math.max(currentDetectorLatencyMs, this.maxDetectorMs);
            this.minDetectorMs = Math.min(currentDetectorLatencyMs, this.minDetectorMs);
            if (this.frameProcessedInOneSecondInterval == 1) {
                Log.d((String)TAG, (String)("Num of Runs: " + this.numRuns));
                Log.d((String)TAG, (String)("Frame latency: max=" + this.maxFrameMs + ", min=" + this.minFrameMs + ", avg=" + this.totalFrameMs / (long)this.numRuns));
                Log.d((String)TAG, (String)("Detector latency: max=" + this.maxDetectorMs + ", min=" + this.minDetectorMs + ", avg=" + this.totalDetectorMs / (long)this.numRuns));
                ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
                this.activityManager.getMemoryInfo(mi);
                long availableMegs = mi.availMem / 0x100000L;
                Log.d((String)TAG, (String)("Memory available in system: " + availableMegs + " MB"));
            }
            this.onSuccess(image, results, graphicOverlay, this.framesPerSecond);
        }).addOnFailureListener((Executor)this.executor, e -> {
            String error = e.getLocalizedMessage();
            if (graphicOverlay != null) {
                graphicOverlay.clear();
                graphicOverlay.postInvalidate();
                Toast.makeText((Context)graphicOverlay.getContext(), (CharSequence)error, (int)0).show();
            }
            Log.d((String)TAG, (String)error);
            e.printStackTrace();
            this.onFailure(e);
        });
    }

    @Override
    public void stop() {
        this.executor.shutdown();
        this.isShutdown = true;
        this.numRuns = 0;
        this.totalFrameMs = 0L;
        this.totalDetectorMs = 0L;
        this.fpsTimer.cancel();
    }

    protected abstract Task<T> detectInImage(InputImage var1);

    protected abstract void onSuccess(@NonNull InputImage var1, @NonNull T var2, @NonNull GraphicOverlay var3, int var4);

    protected abstract void onFailure(@NonNull Exception var1);
}

