/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.mlkit;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.View;
import com.google.android.gms.common.internal.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class GraphicOverlay
extends View {
    private final Object lock = new Object();
    private final List<Graphic> graphics = new ArrayList<Graphic>();
    private final Matrix transformationMatrix = new Matrix();
    private int imageWidth;
    private int imageHeight;
    private float scaleFactor = 1.0f;
    private float postScaleWidthOffset;
    private float postScaleHeightOffset;
    private boolean isImageFlipped;
    private boolean needUpdateTransformation = true;

    public GraphicOverlay(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addOnLayoutChangeListener((view, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
            this.needUpdateTransformation = true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.graphics.clear();
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Graphic graphic) {
        Object object = this.lock;
        synchronized (object) {
            this.graphics.add(graphic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Graphic graphic) {
        Object object = this.lock;
        synchronized (object) {
            this.graphics.remove(graphic);
        }
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageSourceInfo(int imageWidth, int imageHeight, boolean isFlipped) {
        Preconditions.checkState((imageWidth > 0 ? 1 : 0) != 0, (Object)"image width must be positive");
        Preconditions.checkState((imageHeight > 0 ? 1 : 0) != 0, (Object)"image height must be positive");
        Object object = this.lock;
        synchronized (object) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            this.isImageFlipped = isFlipped;
            this.needUpdateTransformation = true;
        }
        this.postInvalidate();
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    private void updateTransformationIfNeeded() {
        if (!this.needUpdateTransformation || this.imageWidth <= 0 || this.imageHeight <= 0) {
            return;
        }
        float viewAspectRatio = (float)this.getWidth() / (float)this.getHeight();
        float imageAspectRatio = (float)this.imageWidth / (float)this.imageHeight;
        this.postScaleWidthOffset = 0.0f;
        this.postScaleHeightOffset = 0.0f;
        if (viewAspectRatio > imageAspectRatio) {
            this.scaleFactor = (float)this.getWidth() / (float)this.imageWidth;
            this.postScaleHeightOffset = ((float)this.getWidth() / imageAspectRatio - (float)this.getHeight()) / 2.0f;
        } else {
            this.scaleFactor = (float)this.getHeight() / (float)this.imageHeight;
            this.postScaleWidthOffset = ((float)this.getHeight() * imageAspectRatio - (float)this.getWidth()) / 2.0f;
        }
        this.transformationMatrix.reset();
        this.transformationMatrix.setScale(this.scaleFactor, this.scaleFactor);
        this.transformationMatrix.postTranslate(-this.postScaleWidthOffset, -this.postScaleHeightOffset);
        if (this.isImageFlipped) {
            this.transformationMatrix.postScale(-1.0f, 1.0f, (float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        }
        this.needUpdateTransformation = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Object object = this.lock;
        synchronized (object) {
            this.updateTransformationIfNeeded();
            for (Graphic graphic : this.graphics) {
                graphic.draw(canvas);
            }
        }
    }

    public static abstract class Graphic {
        private GraphicOverlay overlay;

        public Graphic(GraphicOverlay overlay) {
            this.overlay = overlay;
        }

        public abstract void draw(Canvas var1);

        public float scale(float imagePixel) {
            return imagePixel * this.overlay.scaleFactor;
        }

        public Context getApplicationContext() {
            return this.overlay.getContext().getApplicationContext();
        }

        public boolean isImageFlipped() {
            return this.overlay.isImageFlipped;
        }

        public float translateX(float x) {
            if (this.overlay.isImageFlipped) {
                return (float)this.overlay.getWidth() - (this.scale(x) - this.overlay.postScaleWidthOffset);
            }
            return this.scale(x) - this.overlay.postScaleWidthOffset;
        }

        public float translateY(float y) {
            return this.scale(y) - this.overlay.postScaleHeightOffset;
        }

        public Matrix getTransformationMatrix() {
            return this.overlay.transformationMatrix;
        }

        public void postInvalidate() {
            this.overlay.postInvalidate();
        }
    }
}

