/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.mlkit;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceContour;
import com.google.mlkit.vision.face.FaceLandmark;
import id.vouched.android.mlkit.GraphicOverlay;
import java.util.ArrayList;
import java.util.Locale;

public class FaceGraphic
extends GraphicOverlay.Graphic {
    private static final float FACE_POSITION_RADIUS = 8.0f;
    private static final float ID_TEXT_SIZE = 30.0f;
    private static final float ID_Y_OFFSET = 40.0f;
    private static final float BOX_STROKE_WIDTH = 5.0f;
    private static final int NUM_COLORS = 10;
    private static final int[][] COLORS = new int[][]{{-16777216, -1}, {-1, -65281}, {-16777216, -3355444}, {-1, -65536}, {-1, -16776961}, {-1, -12303292}, {-16777216, -16711681}, {-16777216, -256}, {-1, -16777216}, {-16777216, -16711936}};
    private final Paint facePositionPaint;
    private final Paint[] idPaints;
    private final Paint[] boxPaints;
    private final Paint[] labelPaints;
    private volatile Face face;

    FaceGraphic(GraphicOverlay overlay, Face face) {
        super(overlay);
        this.face = face;
        int selectedColor = -1;
        this.facePositionPaint = new Paint();
        this.facePositionPaint.setColor(-1);
        int numColors = COLORS.length;
        this.idPaints = new Paint[numColors];
        this.boxPaints = new Paint[numColors];
        this.labelPaints = new Paint[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.idPaints[i] = new Paint();
            this.idPaints[i].setColor(COLORS[i][0]);
            this.idPaints[i].setTextSize(30.0f);
            this.boxPaints[i] = new Paint();
            this.boxPaints[i].setColor(COLORS[i][1]);
            this.boxPaints[i].setStyle(Paint.Style.STROKE);
            this.boxPaints[i].setStrokeWidth(5.0f);
            this.labelPaints[i] = new Paint();
            this.labelPaints[i].setColor(COLORS[i][1]);
            this.labelPaints[i].setStyle(Paint.Style.FILL);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        Face face = this.face;
        if (face == null) {
            return;
        }
        float x = this.translateX(face.getBoundingBox().centerX());
        float y = this.translateY(face.getBoundingBox().centerY());
        float left = x - this.scale((float)face.getBoundingBox().width() / 2.0f);
        float top = y - this.scale((float)face.getBoundingBox().height() / 2.0f);
        float right = x + this.scale((float)face.getBoundingBox().width() / 2.0f);
        float bottom = y + this.scale((float)face.getBoundingBox().height() / 2.0f);
        float lineHeight = 35.0f;
        float yLabelOffset = face.getTrackingId() == null ? 0.0f : -lineHeight;
        int colorID = face.getTrackingId() == null ? 0 : Math.abs(face.getTrackingId() % 10);
        float textWidth = this.idPaints[colorID].measureText("ID: " + face.getTrackingId());
        if (face.getSmilingProbability() != null) {
            yLabelOffset -= lineHeight;
            textWidth = Math.max(textWidth, this.idPaints[colorID].measureText(String.format(Locale.US, "Happiness: %.2f", face.getSmilingProbability())));
        }
        if (face.getLeftEyeOpenProbability() != null) {
            yLabelOffset -= lineHeight;
            textWidth = Math.max(textWidth, this.idPaints[colorID].measureText(String.format(Locale.US, "Left eye open: %.2f", face.getLeftEyeOpenProbability())));
        }
        if (face.getRightEyeOpenProbability() != null) {
            yLabelOffset -= lineHeight;
            textWidth = Math.max(textWidth, this.idPaints[colorID].measureText(String.format(Locale.US, "Right eye open: %.2f", face.getRightEyeOpenProbability())));
        }
        yLabelOffset -= 3.0f * lineHeight;
        textWidth = Math.max(textWidth, this.idPaints[colorID].measureText(String.format(Locale.US, "EulerX: %.2f", Float.valueOf(face.getHeadEulerAngleX()))));
        textWidth = Math.max(textWidth, this.idPaints[colorID].measureText(String.format(Locale.US, "EulerY: %.2f", Float.valueOf(face.getHeadEulerAngleY()))));
        textWidth = Math.max(textWidth, this.idPaints[colorID].measureText(String.format(Locale.US, "EulerZ: %.2f", Float.valueOf(face.getHeadEulerAngleZ()))));
        yLabelOffset += 30.0f;
        canvas.drawRect(left, top, right, bottom, this.boxPaints[colorID]);
        if (face.getTrackingId() != null) {
            canvas.drawText("ID: " + face.getTrackingId(), left, top + yLabelOffset, this.idPaints[colorID]);
            yLabelOffset += lineHeight;
        }
        for (FaceContour contour : face.getAllContours()) {
            int type = contour.getFaceContourType();
            if (type != 9 && type != 8 && type != 11 && type != 10) continue;
            ArrayList<PointF> points = new ArrayList<PointF>();
            if (type == 8) {
                points.add((PointF)contour.getPoints().get(4));
                points.add((PointF)contour.getPoints().get(5));
                points.add((PointF)contour.getPoints().get(6));
            } else {
                points.add((PointF)contour.getPoints().get(3));
                points.add((PointF)contour.getPoints().get(4));
                points.add((PointF)contour.getPoints().get(5));
            }
            for (PointF point : points) {
                canvas.drawCircle(this.translateX(point.x), this.translateY(point.y), 8.0f, this.facePositionPaint);
            }
        }
    }

    private void drawFaceLandmark(Canvas canvas, @FaceLandmark.LandmarkType int landmarkType) {
        FaceLandmark faceLandmark = this.face.getLandmark(landmarkType);
        if (faceLandmark != null) {
            canvas.drawCircle(this.translateX(faceLandmark.getPosition().x), this.translateY(faceLandmark.getPosition().y), 8.0f, this.facePositionPaint);
        }
    }
}

