/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.mlkit;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageProxy;
import androidx.exifinterface.media.ExifInterface;
import id.vouched.android.mlkit.FrameMetadata;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";

    @Nullable
    public static Bitmap getBitmap(ByteBuffer data, FrameMetadata metadata) {
        data.rewind();
        byte[] imageInBuffer = new byte[data.limit()];
        data.get(imageInBuffer, 0, imageInBuffer.length);
        try {
            YuvImage image = new YuvImage(imageInBuffer, 17, metadata.getWidth(), metadata.getHeight(), null);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            image.compressToJpeg(new Rect(0, 0, metadata.getWidth(), metadata.getHeight()), 80, (OutputStream)stream);
            Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
            stream.close();
            return BitmapUtils.rotateBitmap(bmp, metadata.getRotation(), false, false);
        }
        catch (Exception e) {
            Log.e((String)"VisionProcessorBase", (String)("Error: " + e.getMessage()));
            return null;
        }
    }

    @RequiresApi(value=19)
    @Nullable
    @ExperimentalGetImage
    public static Bitmap getBitmap(ImageProxy image) {
        FrameMetadata frameMetadata = new FrameMetadata.Builder().setWidth(image.getWidth()).setHeight(image.getHeight()).setRotation(image.getImageInfo().getRotationDegrees()).build();
        ByteBuffer nv21Buffer = BitmapUtils.yuv420ThreePlanesToNV21(image.getImage().getPlanes(), image.getWidth(), image.getHeight());
        return BitmapUtils.getBitmap(nv21Buffer, frameMetadata);
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int rotationDegrees, boolean flipX, boolean flipY) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotationDegrees);
        matrix.postScale(flipX ? -1.0f : 1.0f, flipY ? -1.0f : 1.0f);
        Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (rotatedBitmap != bitmap) {
            bitmap.recycle();
        }
        return rotatedBitmap;
    }

    @Nullable
    public static Bitmap getBitmapFromContentUri(ContentResolver contentResolver, Uri imageUri) throws IOException {
        Bitmap decodedBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)imageUri);
        if (decodedBitmap == null) {
            return null;
        }
        int orientation = BitmapUtils.getExifOrientationTag(contentResolver, imageUri);
        int rotationDegrees = 0;
        boolean flipX = false;
        boolean flipY = false;
        switch (orientation) {
            case 2: {
                flipX = true;
                break;
            }
            case 6: {
                rotationDegrees = 90;
                break;
            }
            case 5: {
                rotationDegrees = 90;
                flipX = true;
                break;
            }
            case 3: {
                rotationDegrees = 180;
                break;
            }
            case 4: {
                flipY = true;
                break;
            }
            case 8: {
                rotationDegrees = -90;
                break;
            }
            case 7: {
                rotationDegrees = -90;
                flipX = true;
                break;
            }
        }
        return BitmapUtils.rotateBitmap(decodedBitmap, rotationDegrees, flipX, flipY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getExifOrientationTag(ContentResolver resolver, Uri imageUri) {
        if (!"content".equals(imageUri.getScheme()) && !"file".equals(imageUri.getScheme())) {
            return 0;
        }
        try (InputStream inputStream = resolver.openInputStream(imageUri);){
            if (inputStream == null) {
                int n = 0;
                return n;
            }
            ExifInterface exif = new ExifInterface(inputStream);
            return exif.getAttributeInt("Orientation", 1);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("failed to open file to read rotation meta data: " + imageUri), (Throwable)e);
            return 0;
        }
    }

    @RequiresApi(value=19)
    private static ByteBuffer yuv420ThreePlanesToNV21(Image.Plane[] yuv420888planes, int width, int height) {
        int imageSize = width * height;
        byte[] out = new byte[imageSize + 2 * (imageSize / 4)];
        if (BitmapUtils.areUVPlanesNV21(yuv420888planes, width, height)) {
            yuv420888planes[0].getBuffer().get(out, 0, imageSize);
            ByteBuffer uBuffer = yuv420888planes[1].getBuffer();
            ByteBuffer vBuffer = yuv420888planes[2].getBuffer();
            vBuffer.get(out, imageSize, 1);
            uBuffer.get(out, imageSize + 1, 2 * imageSize / 4 - 1);
        } else {
            BitmapUtils.unpackPlane(yuv420888planes[0], width, height, out, 0, 1);
            BitmapUtils.unpackPlane(yuv420888planes[1], width, height, out, imageSize + 1, 2);
            BitmapUtils.unpackPlane(yuv420888planes[2], width, height, out, imageSize, 2);
        }
        return ByteBuffer.wrap(out);
    }

    @RequiresApi(value=19)
    private static boolean areUVPlanesNV21(Image.Plane[] planes, int width, int height) {
        int imageSize = width * height;
        ByteBuffer uBuffer = planes[1].getBuffer();
        ByteBuffer vBuffer = planes[2].getBuffer();
        int vBufferPosition = vBuffer.position();
        int uBufferLimit = uBuffer.limit();
        vBuffer.position(vBufferPosition + 1);
        uBuffer.limit(uBufferLimit - 1);
        boolean areNV21 = vBuffer.remaining() == 2 * imageSize / 4 - 2 && vBuffer.compareTo(uBuffer) == 0;
        vBuffer.position(vBufferPosition);
        uBuffer.limit(uBufferLimit);
        return areNV21;
    }

    @TargetApi(value=19)
    private static void unpackPlane(Image.Plane plane, int width, int height, byte[] out, int offset, int pixelStride) {
        ByteBuffer buffer = plane.getBuffer();
        buffer.rewind();
        int numRow = (buffer.limit() + plane.getRowStride() - 1) / plane.getRowStride();
        if (numRow == 0) {
            return;
        }
        int scaleFactor = height / numRow;
        int numCol = width / scaleFactor;
        int outputPos = offset;
        int rowStart = 0;
        for (int row = 0; row < numRow; ++row) {
            int inputPos = rowStart;
            for (int col = 0; col < numCol; ++col) {
                out[outputPos] = buffer.get(inputPos);
                outputPos += pixelStride;
                inputPos += plane.getPixelStride();
            }
            rowStart += plane.getRowStride();
        }
    }
}

