/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.liveness.impl;

import com.google.mlkit.vision.face.Face;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.liveness.Liveness;
import id.vouched.android.liveness.LivenessStep;
import id.vouched.android.liveness.impl.LivenessUtility;

public class LookStraight
implements Liveness {
    private int consecutiveChecks;
    private int numChecks;

    public LookStraight(int numChecks) {
        this.numChecks = numChecks;
        this.consecutiveChecks = numChecks;
    }

    @Override
    public LivenessStep execute(DetectedBox box, Face face, float fps) {
        if (this.consecutiveChecks == 0) {
            return LivenessStep.COMPLETE;
        }
        LivenessUtility.FaceOrientation faceOrientation = LivenessUtility.getFaceOrientation(face);
        if (faceOrientation == null) {
            this.resetValues();
            return LivenessStep.FAIL;
        }
        if (faceOrientation == LivenessUtility.FaceOrientation.CENTER) {
            --this.consecutiveChecks;
        } else {
            this.resetValues();
        }
        return this.consecutiveChecks == 0 ? LivenessStep.COMPLETE : LivenessStep.LOOK_FORWARD;
    }

    @Override
    public void resetValues() {
        this.consecutiveChecks = this.numChecks;
    }
}

