/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.liveness.impl;

import android.graphics.PointF;
import android.util.Pair;
import com.google.mlkit.vision.face.Face;
import com.google.mlkit.vision.face.FaceContour;
import com.google.mlkit.vision.face.FaceLandmark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java9.util.stream.StreamSupport;

public class LivenessUtility {
    static boolean isEyeOpen(Face face, float threshold) {
        Float leftOpen = face.getLeftEyeOpenProbability();
        Float rightOpen = face.getRightEyeOpenProbability();
        if (leftOpen != null && rightOpen != null) {
            boolean isOpen = (double)(leftOpen.floatValue() + rightOpen.floatValue()) / 2.0 > (double)threshold;
            return isOpen;
        }
        return false;
    }

    static boolean isMouthOpened(Face face, float threshold) {
        try {
            ArrayList<PointF> lipsUpperOuterPoints = new ArrayList<PointF>();
            ArrayList<PointF> lipsUpperInnerPoints = new ArrayList<PointF>();
            ArrayList<PointF> lipsLowerInnerPoints = new ArrayList<PointF>();
            ArrayList<PointF> lipsLowerOuterPoints = new ArrayList<PointF>();
            for (FaceContour contour : face.getAllContours()) {
                int type = contour.getFaceContourType();
                if (type == 8) {
                    lipsUpperOuterPoints.add((PointF)contour.getPoints().get(5));
                }
                if (type == 9) {
                    lipsUpperInnerPoints.add((PointF)contour.getPoints().get(4));
                }
                if (type == 10) {
                    lipsLowerInnerPoints.add((PointF)contour.getPoints().get(4));
                }
                if (type != 11) continue;
                lipsLowerOuterPoints.add((PointF)contour.getPoints().get(4));
            }
            List<Pair<PointF, PointF>> topLipPoints = Collections.singletonList(new Pair((Object)((PointF)lipsUpperInnerPoints.get(0)), (Object)((PointF)lipsUpperOuterPoints.get(0))));
            List<Pair<PointF, PointF>> bottomLipPoints = Collections.singletonList(new Pair((Object)((PointF)lipsLowerInnerPoints.get(0)), (Object)((PointF)lipsLowerOuterPoints.get(0))));
            List<Pair<PointF, PointF>> mouthPoints = Collections.singletonList(new Pair((Object)((PointF)lipsLowerInnerPoints.get(0)), (Object)((PointF)lipsUpperInnerPoints.get(0))));
            double topLipDistance = LivenessUtility.distanceFromPoints(topLipPoints);
            double bottomLipDistance = LivenessUtility.distanceFromPoints(bottomLipPoints);
            double lipDistance = Math.min(topLipDistance, bottomLipDistance);
            double mouthDistance = LivenessUtility.distanceFromPoints(mouthPoints);
            boolean mouthOpen = mouthDistance > lipDistance * (double)threshold;
            return mouthOpen;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    static double distanceFromPoints(List<Pair<PointF, PointF>> lipPoints) {
        Double totalDistance = (Double)StreamSupport.stream(lipPoints).map(pts -> LivenessUtility.distance((PointF)pts.first, (PointF)pts.second)).reduce((Object)0.0, (a, b) -> a + b);
        return totalDistance / (double)lipPoints.size();
    }

    static double distance(PointF first, PointF second) {
        float xDistance = first.x - second.x;
        float yDistance = first.y - second.y;
        double distance = Math.sqrt(xDistance * xDistance + yDistance * yDistance);
        return distance;
    }

    static FaceOrientation getFaceOrientation(Face face) {
        FaceLandmark leftEye = face.getLandmark(4);
        FaceLandmark rightEye = face.getLandmark(10);
        FaceLandmark nose = face.getLandmark(6);
        if (leftEye == null || rightEye == null || nose == null) {
            return null;
        }
        float leftDiff = Math.abs(nose.getPosition().x - leftEye.getPosition().x);
        float rightDiff = Math.abs(nose.getPosition().x - rightEye.getPosition().x);
        FaceOrientation faceOrientation = FaceOrientation.CENTER;
        if (leftDiff / rightDiff > 1.5f) {
            faceOrientation = FaceOrientation.RIGHT;
        }
        if (rightDiff / leftDiff > 1.5f) {
            faceOrientation = FaceOrientation.LEFT;
        }
        return faceOrientation;
    }

    static enum FaceOrientation {
        CENTER,
        LEFT,
        RIGHT;

    }
}

