/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.liveness.impl;

import com.google.mlkit.vision.face.Face;
import id.vouched.android.box.BoxUtility;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.liveness.Liveness;
import id.vouched.android.liveness.LivenessStep;
import id.vouched.android.liveness.impl.LookStraight;
import java.util.LinkedList;

public class DistanceCheck
implements Liveness {
    private static final float FACE_SMALL_BOX = 0.013f;
    private boolean hasComplete = false;
    private LinkedList<DetectedBox> boxes = new LinkedList();
    private long lastDistanceCheckStartTime = 0L;
    private int distanceCheckCount = 0;
    private static final int DISTANCE_INTERVAL_SECONDS = 5000;
    private static final int MAX_DISTANCE_INCREASES = 5;
    private static final double DISTANCE_INCREASE_PERCENT_INCREMENT = 0.05;

    @Override
    public LivenessStep execute(DetectedBox box, Face face, float fps) {
        if (this.hasComplete) {
            return LivenessStep.COMPLETE;
        }
        if (new LookStraight(1).execute(box, face, fps) != LivenessStep.COMPLETE) {
            return LivenessStep.LOOK_FORWARD;
        }
        if (!BoxUtility.isSmallBox(box, 0.013f + (float)((double)(0.013f * (float)(this.distanceCheckCount + 1)) * 0.05))) {
            long currentTime = System.currentTimeMillis();
            if ((this.lastDistanceCheckStartTime == 0L || currentTime - this.lastDistanceCheckStartTime > 5000L) && this.distanceCheckCount < 5) {
                this.lastDistanceCheckStartTime = currentTime;
                ++this.distanceCheckCount;
            }
            return LivenessStep.MOVE_AWAY;
        }
        BoxUtility.addBoxes(this.boxes, box, fps);
        if (BoxUtility.foundSteadyBox(this.boxes, fps)) {
            this.hasComplete = true;
            return LivenessStep.CAPTURE_DISTANCE_IMAGE;
        }
        return LivenessStep.HOLD_STEADY;
    }

    @Override
    public void resetValues() {
        this.hasComplete = false;
        this.boxes = new LinkedList();
    }
}

