/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.liveness.impl;

import android.os.SystemClock;
import com.google.mlkit.vision.face.Face;
import id.vouched.android.box.DetectedBox;
import id.vouched.android.liveness.Liveness;
import id.vouched.android.liveness.LivenessStep;
import id.vouched.android.liveness.impl.LivenessUtility;

public class Blinking
implements Liveness {
    private static final float EYE_OPEN_THRESHOLD = 0.6f;
    private static final float LOWER_AMOUNT_STEP = 0.05f;
    private static final float MIN_LOWER_AMOUNT_STEP = -0.3f;
    private int successfulChecksNeeded;
    private int numChecks;
    private boolean previousEyeIsOpen;
    private long thresholdLowerTimeMs;
    private float lowerAmount;

    public Blinking(int numChecks) {
        this.numChecks = numChecks;
        this.successfulChecksNeeded = numChecks;
        this.previousEyeIsOpen = true;
        this.thresholdLowerTimeMs = Long.MIN_VALUE;
        this.lowerAmount = 0.05f;
    }

    @Override
    public LivenessStep execute(DetectedBox box, Face face, float fps) {
        if (this.successfulChecksNeeded == 0) {
            return LivenessStep.COMPLETE;
        }
        long frameTimeMs = SystemClock.elapsedRealtime();
        if (this.thresholdLowerTimeMs == Long.MIN_VALUE || frameTimeMs > this.thresholdLowerTimeMs) {
            this.thresholdLowerTimeMs = frameTimeMs + 3000L;
            this.lowerAmount = Math.max(this.lowerAmount - 0.05f, -0.3f);
        }
        boolean eyeIsOpen = LivenessUtility.isEyeOpen(face, 0.6f + this.lowerAmount);
        if (!this.previousEyeIsOpen && eyeIsOpen) {
            --this.successfulChecksNeeded;
        }
        this.previousEyeIsOpen = eyeIsOpen;
        return this.successfulChecksNeeded == 0 ? LivenessStep.COMPLETE : LivenessStep.BLINK_EYES;
    }

    @Override
    public void resetValues() {
        this.successfulChecksNeeded = this.numChecks;
        this.previousEyeIsOpen = true;
        this.thresholdLowerTimeMs = Long.MIN_VALUE;
        this.lowerAmount = 0.05f;
    }
}

