/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.event;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import java.util.HashMap;

@Keep
public class SessionEventType {
    public final String name;
    public static final SessionEventType SessionStarted = new SessionEventType("SESSION_STARTED");
    public static final SessionEventType SessionEnded = new SessionEventType("SESSION_ENDED");
    public static final SessionEventType PostFrontId = new SessionEventType("POST_FRONT_ID");
    public static final SessionEventType PostBackId = new SessionEventType("POST_BACK_ID");
    public static final SessionEventType PostFace = new SessionEventType("POST_FACE");
    public static final SessionEventType PostConfirm = new SessionEventType("POST_CONFIRM");
    public static final SessionEventType PostReverification = new SessionEventType("POST_REVERIFICATION");
    public static final SessionEventType BarcodeDetected = new SessionEventType("BARCODE_DETECTED");
    public static final SessionEventType BarcodeDetectionError = new SessionEventType("BARCODE_DETECTION_ERROR");

    protected SessionEventType(String name) {
        this.name = name;
    }

    HashMap<String, Object> getParams() {
        return new HashMap<String, Object>();
    }

    @NonNull
    public String toString() {
        return this.name;
    }

    public static class ApiError
    extends SessionEventType {
        private final String errorClass;
        private final String stage;

        public ApiError(String errorClass, String stage) {
            super("API_ERROR");
            this.errorClass = errorClass;
            this.stage = stage;
        }

        @Override
        HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("errorClass", this.errorClass);
            result.put("stage", this.stage);
            return result;
        }
    }

    public static class ApiSessionRequestSuccess
    extends SessionEventType {
        private final String stage;
        private final String[] errors;
        private final String[] signals;
        private final String documentType;

        public ApiSessionRequestSuccess(String stage, String[] errors, String[] signals, String documentType) {
            super("API_SESSION_REQUEST_SUCCESS");
            this.stage = stage;
            this.errors = errors;
            this.signals = signals;
            this.documentType = documentType;
        }

        @Override
        HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("stage", this.stage);
            for (String error : this.errors) {
                result.put("error_" + error, true);
            }
            for (String signal : this.signals) {
                result.put("signal_" + signal, true);
            }
            result.put("documentType", this.documentType);
            return result;
        }
    }

    public static class FaceDetected
    extends SessionEventType {
        private final long holdSteadyTime;

        public FaceDetected(long holdSteadyTime) {
            super("FACE_DETECTED");
            this.holdSteadyTime = holdSteadyTime;
        }

        @Override
        HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("holdSteadyTime", this.holdSteadyTime);
            return result;
        }
    }

    public static class CardDetectionTimeout
    extends SessionEventType {
        private final long timeout;

        public CardDetectionTimeout(long timeout) {
            super("CARD_DETECTION_TIMEOUT");
            this.timeout = timeout;
        }

        @Override
        public HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("timeout", this.timeout);
            return result;
        }
    }

    public static class CardDetected
    extends SessionEventType {
        private final boolean usedFallbackImage;
        private final long captureTime;
        private final long captureSessionTime;
        private final boolean withException;
        private final String exceptionMessage;
        private final boolean enhanceInfoEnabled;
        private final boolean enhancedInfoFound;

        public CardDetected(boolean usedFallbackImage, long captureTime, long captureSessionTime, boolean withException, String exceptionMessage, boolean enhanceInfoEnabled, boolean enhancedInfoFound) {
            super("CARD_DETECTED");
            this.usedFallbackImage = usedFallbackImage;
            this.captureTime = captureTime;
            this.captureSessionTime = captureSessionTime;
            this.withException = withException;
            this.exceptionMessage = exceptionMessage;
            this.enhanceInfoEnabled = enhanceInfoEnabled;
            this.enhancedInfoFound = enhancedInfoFound;
        }

        @Override
        public HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("usedFallbackImage", this.usedFallbackImage);
            result.put("captureTime", this.captureTime);
            result.put("captureSessionTime", this.captureSessionTime);
            result.put("withException", this.withException);
            result.put("exceptionMessage", this.exceptionMessage);
            result.put("enhanceInfoEnabled", this.enhanceInfoEnabled);
            result.put("enhancedInfoFound", this.enhancedInfoFound);
            return result;
        }
    }

    public static class CameraHelperModeChanged
    extends SessionEventType {
        private final String mode;

        public CameraHelperModeChanged(String mode) {
            super("CAMERA_HELPER_MODE_CHANGED");
            this.mode = mode;
        }

        @Override
        public HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("mode", this.mode);
            return result;
        }
    }

    public static class StartingCameraHelper
    extends SessionEventType {
        private final String mode;

        public StartingCameraHelper(String mode) {
            super("STARTING_CAMERA_HELPER");
            this.mode = mode;
        }

        @Override
        public HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("mode", this.mode);
            return result;
        }
    }

    public static class CardDetectionError
    extends SessionEventType {
        private final String exceptionName;

        public CardDetectionError(String exceptionName) {
            super("CARD_DETECTION_ERROR");
            this.exceptionName = exceptionName;
        }

        @Override
        public HashMap<String, Object> getParams() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("exceptionName", this.exceptionName);
            return result;
        }
    }
}

