/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.event;

import android.os.Build;
import androidx.annotation.Keep;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import id.vouched.android.event.SessionEventType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class AEvent {
    private static final String CURRENT_SDK_VERSION = "1.3.8";
    private String userId;
    private UUID deviceId;
    private String eventType;
    private long time;
    private String appVersion;
    private String osName;
    private String osVersion;
    private String deviceBrand;
    private String deviceManufacturer;
    private String deviceModel;
    private long sessionId;
    private int eventId;
    private UUID insertId;
    private SessionEventType eventTypeData;

    public AEvent(String userId, UUID deviceId2, SessionEventType eventTypeData, long sessionId2, int eventId) {
        this.userId = userId;
        this.deviceId = deviceId2;
        this.eventType = eventTypeData.name;
        this.time = System.currentTimeMillis();
        this.appVersion = CURRENT_SDK_VERSION;
        this.osName = "Android";
        this.osVersion = Build.VERSION.RELEASE;
        this.deviceBrand = Build.BRAND;
        this.deviceManufacturer = Build.MANUFACTURER;
        this.deviceModel = Build.MODEL;
        this.sessionId = sessionId2;
        this.eventId = eventId;
        this.insertId = UUID.randomUUID();
        this.eventTypeData = eventTypeData;
    }

    public JSONObject toJson() throws JSONException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        JSONObject jsonObj = new JSONObject(gson.toJson((Object)this));
        HashMap<String, Object> eventProperties = this.eventTypeData.getParams();
        if (eventProperties != null && !eventProperties.isEmpty()) {
            JSONObject jsonProperties = new JSONObject();
            for (Map.Entry<String, Object> entry : eventProperties.entrySet()) {
                jsonProperties.put(entry.getKey(), entry.getValue());
            }
            jsonObj.put("event_properties", (Object)jsonProperties);
        }
        return jsonObj;
    }

    public String getUserId() {
        return this.userId;
    }

    public UUID getDeviceId() {
        return this.deviceId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getTime() {
        return this.time;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getDeviceBrand() {
        return this.deviceBrand;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public int getEventId() {
        return this.eventId;
    }

    public UUID getInsertId() {
        return this.insertId;
    }
}

