/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.env;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Environment;
import id.vouched.android.VouchedLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImageUtils {
    static final int kMaxChannelValue = 262143;

    public static int getYUVByteSize(int width, int height) {
        int ySize = width * height;
        int uvSize = (width + 1) / 2 * ((height + 1) / 2) * 2;
        return ySize + uvSize;
    }

    public static void saveBitmap(Bitmap bitmap) {
        ImageUtils.saveBitmap(bitmap, "preview.png");
    }

    public static void saveBitmap(Bitmap bitmap, String filename) {
        String fname;
        String root = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "tensorflow";
        File myDir = new File(root);
        File file = new File(myDir, fname = filename);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 99, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            VouchedLogger.getInstance().error(e.getMessage());
        }
    }

    public static void convertYUV420SPToARGB8888(byte[] input, int width, int height, int[] output) {
        int frameSize = width * height;
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int uvp = frameSize + (j >> 1) * width;
            int u = 0;
            int v = 0;
            int i = 0;
            while (i < width) {
                int y = 0xFF & input[yp];
                if ((i & 1) == 0) {
                    v = 0xFF & input[uvp++];
                    u = 0xFF & input[uvp++];
                }
                output[yp] = ImageUtils.YUV2RGB(y, u, v);
                ++i;
                ++yp;
            }
        }
    }

    private static int YUV2RGB(int y, int u, int v) {
        y = y - 16 < 0 ? 0 : y - 16;
        int y1192 = 1192 * y;
        int r = y1192 + 1634 * (v -= 128);
        int g = y1192 - 833 * v - 400 * (u -= 128);
        int b = y1192 + 2066 * u;
        int n = r > 262143 ? 262143 : (r = r < 0 ? 0 : r);
        int n2 = g > 262143 ? 262143 : (g = g < 0 ? 0 : g);
        b = b > 262143 ? 262143 : (b < 0 ? 0 : b);
        return 0xFF000000 | r << 6 & 0xFF0000 | g >> 2 & 0xFF00 | b >> 10 & 0xFF;
    }

    public static void convertYUV420ToARGB8888(byte[] yData, byte[] uData, byte[] vData, int width, int height, int yRowStride, int uvRowStride, int uvPixelStride, int[] out) {
        int yp = 0;
        for (int j = 0; j < height; ++j) {
            int pY = yRowStride * j;
            int pUV = uvRowStride * (j >> 1);
            for (int i = 0; i < width; ++i) {
                int uv_offset = pUV + (i >> 1) * uvPixelStride;
                out[yp++] = ImageUtils.YUV2RGB(0xFF & yData[pY + i], 0xFF & uData[uv_offset], 0xFF & vData[uv_offset]);
            }
        }
    }

    public static Matrix getTransformationMatrix(int srcWidth, int srcHeight, int dstWidth, int dstHeight, int applyRotation, boolean maintainAspectRatio) {
        int inHeight;
        Matrix matrix = new Matrix();
        if (applyRotation != 0) {
            matrix.postTranslate((float)(-srcWidth) / 2.0f, (float)(-srcHeight) / 2.0f);
            matrix.postRotate((float)applyRotation);
        }
        boolean transpose = (Math.abs(applyRotation) + 90) % 180 == 0;
        int inWidth = transpose ? srcHeight : srcWidth;
        int n = inHeight = transpose ? srcWidth : srcHeight;
        if (inWidth != dstWidth || inHeight != dstHeight) {
            float scaleFactorX = (float)dstWidth / (float)inWidth;
            float scaleFactorY = (float)dstHeight / (float)inHeight;
            if (maintainAspectRatio) {
                float scaleFactor = Math.max(scaleFactorX, scaleFactorY);
                matrix.postScale(scaleFactor, scaleFactor);
            } else {
                matrix.postScale(scaleFactorX, scaleFactorY);
            }
        }
        if (applyRotation != 0) {
            matrix.postTranslate((float)dstWidth / 2.0f, (float)dstHeight / 2.0f);
        }
        return matrix;
    }
}

