/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.env;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import java.util.Vector;

public class BorderedText {
    private final Paint interiorPaint = new Paint();
    private final Paint exteriorPaint;
    private final float textSize;

    public BorderedText(float textSize) {
        this(-1, -16777216, textSize);
    }

    public BorderedText(int interiorColor, int exteriorColor, float textSize) {
        this.interiorPaint.setTextSize(textSize);
        this.interiorPaint.setColor(interiorColor);
        this.interiorPaint.setStyle(Paint.Style.FILL);
        this.interiorPaint.setAntiAlias(false);
        this.interiorPaint.setAlpha(255);
        this.exteriorPaint = new Paint();
        this.exteriorPaint.setTextSize(textSize);
        this.exteriorPaint.setColor(exteriorColor);
        this.exteriorPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.exteriorPaint.setStrokeWidth(textSize / 8.0f);
        this.exteriorPaint.setAntiAlias(false);
        this.exteriorPaint.setAlpha(255);
        this.textSize = textSize;
    }

    public void setTypeface(Typeface typeface) {
        this.interiorPaint.setTypeface(typeface);
        this.exteriorPaint.setTypeface(typeface);
    }

    public void drawText(Canvas canvas, float posX, float posY, String text) {
        canvas.drawText(text, posX, posY, this.exteriorPaint);
        canvas.drawText(text, posX, posY, this.interiorPaint);
    }

    public void drawText(Canvas canvas, float posX, float posY, String text, Paint bgPaint) {
        float width = this.exteriorPaint.measureText(text);
        float textSize = this.exteriorPaint.getTextSize();
        Paint paint = new Paint(bgPaint);
        paint.setStyle(Paint.Style.FILL);
        paint.setAlpha(160);
        canvas.drawRect(posX, posY + (float)((int)textSize), posX + (float)((int)width), posY, paint);
        canvas.drawText(text, posX, posY + textSize, this.interiorPaint);
    }

    public void drawLines(Canvas canvas, float posX, float posY, Vector<String> lines) {
        int lineNum = 0;
        for (String line : lines) {
            this.drawText(canvas, posX, posY - this.getTextSize() * (float)(lines.size() - lineNum - 1), line);
            ++lineNum;
        }
    }

    public void setInteriorColor(int color) {
        this.interiorPaint.setColor(color);
    }

    public void setExteriorColor(int color) {
        this.exteriorPaint.setColor(color);
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setAlpha(int alpha) {
        this.interiorPaint.setAlpha(alpha);
        this.exteriorPaint.setAlpha(alpha);
    }

    public void getTextBounds(String line, int index, int count, Rect lineBounds) {
        this.interiorPaint.getTextBounds(line, index, count, lineBounds);
    }

    public void setTextAlign(Paint.Align align) {
        this.interiorPaint.setTextAlign(align);
        this.exteriorPaint.setTextAlign(align);
    }
}

