/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android.backend;

import android.os.Build;
import com.android.volley.AuthFailureError;
import com.android.volley.ClientError;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.ServerError;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.google.gson.Gson;
import id.vouched.android.VouchedExceptionHandler;
import id.vouched.android.VouchedLogger;
import id.vouched.android.VouchedSessionParameters;
import id.vouched.android.event.SessionEventType;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.model.AuthenticateResult;
import id.vouched.android.model.AuthenticationResponse;
import id.vouched.android.model.Job;
import id.vouched.android.model.JobError;
import id.vouched.android.model.JobProperty;
import id.vouched.android.model.JobResponse;
import id.vouched.android.model.Params;
import id.vouched.android.model.RequestType;
import id.vouched.android.model.Signal;
import id.vouched.android.model.Stage;
import id.vouched.android.model.error.ConnectionError;
import id.vouched.android.model.error.InvalidApiKeyError;
import id.vouched.android.model.error.InvalidRequestError;
import id.vouched.android.model.error.InvalidUrlError;
import id.vouched.android.model.error.TimeoutError;
import id.vouched.android.model.error.VouchedError;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java9.util.function.Consumer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class API {
    private static int TIMEOUT_THRESHOLD = 72000;
    private static final int RETRIES = 0;
    private static final Gson GSON = new Gson();

    private static VouchedExceptionHandler getVouchedExceptionHandler() {
        return SessionEventManager.Companion.getInstance();
    }

    public static void jobSession(RequestType requestType, RequestQueue mQueue, VouchedSessionParameters sessionParameters, final String apiKey, final String apiUrl, final Stage stage, final String token, Params params, final Consumer<JobResponse> callback) {
        VouchedLogger.getInstance().debug("Sending Job details to Vouched API");
        final String URL2 = apiUrl + "/api/jobs/session";
        final JSONObject sessionJobRequest = new JSONObject();
        try {
            sessionJobRequest.put("type", (Object)requestType.value);
            sessionJobRequest.put("stage", (Object)stage.value);
            sessionJobRequest.put("params", (Object)params.toJSON());
            sessionJobRequest.put("jobConfigId", (Object)"__token_no_review__");
            if (sessionParameters.getCallbackURL() != null) {
                sessionJobRequest.put("callbackURL", (Object)sessionParameters.getCallbackURL());
            }
            if (sessionParameters.getGroupId() != null) {
                sessionJobRequest.put("accountGroupSid", (Object)sessionParameters.getGroupId());
            }
            if (sessionParameters.getProperties() != null && sessionParameters.getProperties().length > 0) {
                JSONArray properties = new JSONArray();
                for (JobProperty p : sessionParameters.getProperties()) {
                    properties.put((Object)p.toJSON());
                }
                sessionJobRequest.put("properties", (Object)properties);
            }
        }
        catch (JSONException e) {
            callback.accept((Object)new JobResponse(null, new VouchedError(String.format(Locale.ENGLISH, "Unable to create JSON object from params: %s", params))));
            return;
        }
        JsonObjectRequest objRequest = new JsonObjectRequest(1, URL2, sessionJobRequest, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                VouchedLogger.getInstance().debug("Retrieve response from Vouched API");
                Job job = (Job)GSON.fromJson(response.toString(), Job.class);
                JobError[] jobErrors = job.getErrors();
                int totalErrors = jobErrors != null ? jobErrors.length : 0;
                Signal[] jobSignals = job.getSignals();
                int totalSignals = jobSignals != null ? jobSignals.length : 0;
                String[] errors = new String[totalErrors];
                String[] signals = new String[totalSignals];
                if (Build.VERSION.SDK_INT >= 24) {
                    if (jobErrors != null) {
                        errors = (String[])Arrays.stream(jobErrors).map(JobError::getType).toArray(String[]::new);
                    }
                    if (jobSignals != null) {
                        signals = (String[])Arrays.stream(jobSignals).map(Signal::getType).toArray(String[]::new);
                    }
                } else {
                    int i;
                    for (i = 0; i < totalErrors; ++i) {
                        errors[i] = jobErrors[i].getType();
                    }
                    for (i = 0; i < totalSignals; ++i) {
                        signals[i] = jobSignals[i].getType();
                    }
                }
                callback.accept((Object)new JobResponse(job, null));
                API.getVouchedExceptionHandler().sendEvent(new SessionEventType.ApiSessionRequestSuccess(stage.name(), errors, signals, job.getResult().getType()));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                VouchedLogger.getInstance().error("Retrieve error from Vouched API");
                VouchedError vouchedError = API.getVouchedError(error, apiUrl, apiKey, URL2, sessionJobRequest.toString());
                callback.accept((Object)new JobResponse(null, vouchedError));
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                return API.getDefaultHeaders(apiKey, token);
            }
        };
        objRequest.setRetryPolicy(new RetryPolicy(){

            public int getCurrentTimeout() {
                return TIMEOUT_THRESHOLD;
            }

            public int getCurrentRetryCount() {
                return 0;
            }

            public void retry(VolleyError error) {
                if (error.networkResponse != null && error.networkResponse.statusCode == 401) {
                    VouchedLogger.getInstance().error("Unable to authenticate");
                } else if (error instanceof com.android.volley.TimeoutError) {
                    API.getVouchedExceptionHandler().postException((Exception)error);
                }
            }
        });
        mQueue.add((Request)objRequest);
    }

    public static void authentication(RequestQueue mQueue, final String apiKey, final String apiUrl, String jobId, String image, boolean matchId, final Consumer<AuthenticationResponse> callback) {
        VouchedLogger.getInstance().debug("Sending authentication request to Vouched API");
        final String URL2 = apiUrl + "/api/identity/authenticate";
        final JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("id", (Object)jobId);
            jsonBody.put("userPhoto", (Object)image);
            jsonBody.put("matchId", matchId);
        }
        catch (JSONException e) {
            callback.accept((Object)new AuthenticationResponse(null, new VouchedError(String.format(Locale.ENGLISH, "Unable to create JSON object for authentication", new Object[0]))));
            return;
        }
        JsonObjectRequest objRequest = new JsonObjectRequest(1, URL2, jsonBody, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                VouchedLogger.getInstance().debug("Retrieve response from Vouched API");
                AuthenticateResult result = (AuthenticateResult)GSON.fromJson(response.toString(), AuthenticateResult.class);
                callback.accept((Object)new AuthenticationResponse(result, null));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                VouchedLogger.getInstance().error("Retrieve error from Vouched API");
                VouchedError vouchedError = API.getVouchedError(error, apiUrl, apiKey, URL2, jsonBody.toString());
                callback.accept((Object)new AuthenticationResponse(null, vouchedError));
            }
        }){

            public Map<String, String> getHeaders() throws AuthFailureError {
                return API.getDefaultHeaders(apiKey, null);
            }
        };
        objRequest.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(TIMEOUT_THRESHOLD, 0, 1.0f));
        mQueue.add((Request)objRequest);
    }

    private static Map<String, String> getDefaultHeaders(String apiKey, String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String userAgent = System.getProperty("http.agent");
        String vouchedAgent = String.format("%s Vouched/%s (Android)", userAgent, "1.3.8");
        headers.put("User-agent", vouchedAgent);
        headers.put("Content-Type", "application/json");
        headers.put("x-api-public-key", apiKey);
        if (token != null) {
            headers.put("x-session-token", token);
        }
        return headers;
    }

    private static VouchedError getVouchedError(VolleyError error, String apiUrl, String apiKey, String URL2, String request) {
        VouchedError vouchedError = error instanceof NoConnectionError ? new InvalidUrlError(String.format(Locale.ENGLISH, "Unable to connect: %s", error.getLocalizedMessage())) : (error instanceof AuthFailureError ? new InvalidApiKeyError(String.format(Locale.ENGLISH, "Unable to authenticate with key: %s", apiKey)) : (error instanceof com.android.volley.TimeoutError ? new TimeoutError(null) : (error instanceof NetworkError ? new ConnectionError(String.format(Locale.ENGLISH, error.getLocalizedMessage(), new Object[0])) : (error instanceof ClientError ? new InvalidRequestError(request) : (error instanceof ServerError ? new id.vouched.android.model.error.ServerError(null) : (error.networkResponse != null ? new VouchedError(String.format(Locale.ENGLISH, "There was an unspecified network error with %d status code", error.networkResponse.statusCode)) : new VouchedError(String.format("There was an unspecified network error: %s", error.getLocalizedMessage()))))))));
        return vouchedError;
    }
}

