/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.android.volley.toolbox.Volley;
import id.vouched.android.BarcodeResult;
import id.vouched.android.CardDetectResult;
import id.vouched.android.FaceDetectResult;
import id.vouched.android.VouchedSessionParameters;
import id.vouched.android.backend.API;
import id.vouched.android.event.SessionEventType;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.model.AuthenticationResponse;
import id.vouched.android.model.Job;
import id.vouched.android.model.JobResponse;
import id.vouched.android.model.Params;
import id.vouched.android.model.RequestType;
import id.vouched.android.model.Stage;
import id.vouched.android.model.error.VouchedError;
import id.vouched.android.utils.BitmapUtils;
import java.io.Serializable;
import java9.util.function.Consumer;

public class VouchedSession
implements Serializable {
    private static final String DEFAULT_URL = "https://verify.vouched.id";
    private final String apiKey;
    private final String apiUrl;
    private final VouchedSessionParameters sessionParameters;
    private String token;

    public VouchedSession(String apiKey) {
        this(apiKey, new VouchedSessionParameters.Builder().build(), DEFAULT_URL);
    }

    public VouchedSession(String apiKey, VouchedSessionParameters sessionParameters) {
        this(apiKey, sessionParameters, DEFAULT_URL);
    }

    public VouchedSession(String apiKey, String apiUrl) {
        this(apiKey, new VouchedSessionParameters.Builder().build(), apiUrl);
    }

    public VouchedSession(String apiKey, VouchedSessionParameters sessionParameters, String apiUrl) {
        this.apiKey = apiKey;
        this.sessionParameters = sessionParameters;
        this.apiUrl = this.removeLastSlash(apiUrl);
        this.token = sessionParameters.getToken();
        SessionEventManager.Companion.getInstance().sendEvent(SessionEventType.SessionStarted);
    }

    public void postFrontId(Context context, @NonNull Bitmap idImage, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        this.postFrontId(context, BitmapUtils.toBase64(idImage), paramsBuilder, jobResponseListener);
    }

    public void postFrontId(Context context, @NonNull String idImage, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.id, this.token, this.getBuilder(paramsBuilder).withIdPhoto(idImage).build(), this.persistToken(jobResponseListener, SessionEventType.PostFrontId, Stage.id));
    }

    public void postFrontId(Context context, @NonNull CardDetectResult cardDetectResult, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        Params.Builder builder = this.getBuilder(paramsBuilder);
        if (cardDetectResult.getDistanceImage() != null) {
            builder.withIdDistancePhoto(cardDetectResult.getDistanceImage());
        }
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.id, this.token, builder.withIdPhoto(cardDetectResult.getImage()).withBarcodeText(cardDetectResult.getBarcodeText()).build(), this.persistToken(jobResponseListener, SessionEventType.PostFrontId, Stage.id));
    }

    public void postBackId(Context context, @NonNull BarcodeResult barcodeResult, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.backId, this.token, this.getBuilder(paramsBuilder).withBackIdPhoto(barcodeResult.getImage()).withBarcodeText(barcodeResult.getValue()).build(), this.persistToken(jobResponseListener, SessionEventType.PostBackId, Stage.backId));
    }

    public void postBackId(Context context, @NonNull CardDetectResult cardDetectResult, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.backId, this.token, this.getBuilder(paramsBuilder).withBackIdPhoto(cardDetectResult.getImage()).build(), this.persistToken(jobResponseListener, SessionEventType.PostBackId, Stage.backId));
    }

    public void postBackId(Context context, @NonNull String idImage, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.backId, this.token, this.getBuilder(paramsBuilder).withBackIdPhoto(idImage).build(), this.persistToken(jobResponseListener, SessionEventType.PostBackId, Stage.backId));
    }

    public void postBackId(Context context, @NonNull Bitmap idImage, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        this.postBackId(context, BitmapUtils.toBase64(idImage), paramsBuilder, jobResponseListener);
    }

    public void postFace(Context context, @NonNull String selfieImage, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.face, this.token, this.getBuilder(paramsBuilder).withUserPhoto(selfieImage).build(), this.persistToken(jobResponseListener, SessionEventType.PostFace, Stage.face));
    }

    public void postFace(Context context, @NonNull FaceDetectResult faceDetectResult, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        this.postFace(context, RequestType.ID_VERIFICATION, faceDetectResult, paramsBuilder, jobResponseListener);
    }

    public void postSelfieVerification(Context context, @NonNull FaceDetectResult faceDetectResult, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        this.postFace(context, RequestType.SELFIE_VERIFICATION, faceDetectResult, paramsBuilder, jobResponseListener);
    }

    private void postFace(Context context, RequestType requestType, @NonNull FaceDetectResult faceDetectResult, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        Params.Builder builder = this.getBuilder(paramsBuilder);
        if (faceDetectResult.getUserDistanceImage() != null) {
            builder.withUserDistancePhoto(faceDetectResult.getUserDistanceImage());
        }
        API.jobSession(requestType, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.face, this.token, builder.withUserPhoto(faceDetectResult.getImage()).build(), this.persistToken(jobResponseListener, SessionEventType.PostFace, Stage.face));
    }

    public void confirm(Context context, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        API.jobSession(RequestType.ID_VERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.confirm, this.token, this.getBuilder(paramsBuilder).build(), this.persistToken(jobResponseListener, SessionEventType.PostConfirm, Stage.confirm));
    }

    public void postReverification(Context context, @NonNull String jobId, @NonNull String userPhoto, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        this.postReverification(context, jobId, "selfie", userPhoto, paramsBuilder, jobResponseListener);
    }

    public void postReverification(Context context, @NonNull String jobId, @NonNull String matchType, @NonNull String userPhoto, Params.Builder paramsBuilder, OnJobResponseListener jobResponseListener) {
        Params.Builder builder = this.getBuilder(paramsBuilder).withAuthJobId(jobId).withPhotoType(matchType).withUserPhoto(userPhoto);
        API.jobSession(RequestType.ID_REVERIFICATION, Volley.newRequestQueue((Context)context), this.sessionParameters, this.apiKey, this.apiUrl, Stage.confirm, null, builder.build(), this.persistToken(jobResponseListener, SessionEventType.PostReverification, Stage.confirm));
    }

    public void postAuthenticate(Context context, String jobId, @NonNull FaceDetectResult faceDetectResult, boolean matchId, OnAuthenticationResponseListener authenticationResponseListener) {
        API.authentication(Volley.newRequestQueue((Context)context), this.apiKey, this.apiUrl, jobId, faceDetectResult.getImage(), matchId, (Consumer<AuthenticationResponse>)((Consumer)authenticationResponseListener::onAuthenticationResponse));
    }

    private Params.Builder getBuilder(Params.Builder currentBuilder) {
        return currentBuilder != null ? currentBuilder : new Params.Builder();
    }

    private Consumer<JobResponse> persistToken(OnJobResponseListener jobResponseListener) {
        return this.persistToken(jobResponseListener, null, null);
    }

    private Consumer<JobResponse> persistToken(OnJobResponseListener jobResponseListener, SessionEventType afterwardsEvent, Stage stage) {
        return response -> {
            Job job = response.getJob();
            if (job != null) {
                this.token = job.getToken();
                SessionEventManager.Companion.getInstance().setJobId(job.getId());
            }
            if (afterwardsEvent != null) {
                SessionEventManager.Companion.getInstance().sendEvent(afterwardsEvent);
            }
            if (response.getError() != null) {
                VouchedError error = response.getError();
                SessionEventManager.Companion.getInstance().sendEvent(new SessionEventType.ApiError(error.getClass().getSimpleName(), stage != null ? stage.value : ""));
            } else if (afterwardsEvent == SessionEventType.PostConfirm) {
                SessionEventManager.Companion.getInstance().sendEvent(SessionEventType.SessionEnded);
            }
            if (stage == Stage.confirm) {
                this.token = null;
            }
            jobResponseListener.onJobResponse((JobResponse)response);
        };
    }

    private String removeLastSlash(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static interface OnJobResponseListener {
        public void onJobResponse(JobResponse var1);
    }

    public static interface OnAuthenticationResponseListener {
        public void onAuthenticationResponse(AuthenticationResponse var1);
    }
}

