/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.widget.ImageView;
import id.vouched.android.BarcodeDetect;
import id.vouched.android.CardDetect;
import id.vouched.android.CardDetectOptions;
import id.vouched.android.FaceDetect;
import id.vouched.android.FaceDetectOptions;
import id.vouched.android.TimeoutListener;
import id.vouched.android.VouchedCameraHelperTimeout;

public class VouchedCameraHelperOptions {
    private CardDetectOptions cardDetectOptions;
    private CardDetect.OnDetectResultListener cardDetectResultListener;
    private BarcodeDetect.OnBarcodeResultListener barcodeDetectResultListener;
    private FaceDetectOptions faceDetectOptions;
    private FaceDetect.OnDetectResultListener faceDetectResultListener;
    private ImageView imageView;
    private boolean disableFlash;
    private VouchedCameraHelperTimeout vouchedCameraHelperTimeout;

    private VouchedCameraHelperOptions(CardDetectOptions cardDetectOptions, CardDetect.OnDetectResultListener cardDetectResultListener, BarcodeDetect.OnBarcodeResultListener barcodeDetectResultListener, FaceDetectOptions faceDetectOptions, FaceDetect.OnDetectResultListener faceDetectResultListener, VouchedCameraHelperTimeout vouchedCameraHelperTimeout, ImageView imageView, boolean disableFlash) {
        this.cardDetectOptions = cardDetectOptions;
        this.cardDetectResultListener = cardDetectResultListener;
        this.barcodeDetectResultListener = barcodeDetectResultListener;
        this.faceDetectOptions = faceDetectOptions;
        this.faceDetectResultListener = faceDetectResultListener;
        this.imageView = imageView;
        this.disableFlash = disableFlash;
        this.vouchedCameraHelperTimeout = vouchedCameraHelperTimeout;
    }

    public CardDetectOptions getCardDetectOptions() {
        return this.cardDetectOptions;
    }

    public CardDetect.OnDetectResultListener getCardDetectResultListener() {
        return this.cardDetectResultListener;
    }

    public BarcodeDetect.OnBarcodeResultListener getBarcodeDetectResultListener() {
        return this.barcodeDetectResultListener;
    }

    public FaceDetectOptions getFaceDetectOptions() {
        return this.faceDetectOptions;
    }

    public FaceDetect.OnDetectResultListener getFaceDetectResultListener() {
        return this.faceDetectResultListener;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public boolean isCameraFlashDisabled() {
        return this.disableFlash;
    }

    public VouchedCameraHelperTimeout getVouchedCameraHelperTimeout() {
        return this.vouchedCameraHelperTimeout;
    }

    public static class Builder {
        private CardDetectOptions cardDetectOptions;
        private CardDetect.OnDetectResultListener cardDetectResultListener;
        private BarcodeDetect.OnBarcodeResultListener barcodeDetectResultListener;
        private FaceDetectOptions faceDetectOptions;
        private FaceDetect.OnDetectResultListener faceDetectResultListener;
        private ImageView imageView;
        private boolean disableFlash;
        private VouchedCameraHelperTimeout vouchedCameraHelperTimeout;

        public Builder withCardDetectOptions(CardDetectOptions cardDetectOptions) {
            this.cardDetectOptions = cardDetectOptions;
            return this;
        }

        public Builder withCardDetectResultListener(CardDetect.OnDetectResultListener cardDetectResultListener) {
            this.cardDetectResultListener = cardDetectResultListener;
            return this;
        }

        public Builder withBarcodeDetectResultListener(BarcodeDetect.OnBarcodeResultListener barcodeDetectResultListener) {
            this.barcodeDetectResultListener = barcodeDetectResultListener;
            return this;
        }

        public Builder withFaceDetectOptions(FaceDetectOptions faceDetectOptions) {
            this.faceDetectOptions = faceDetectOptions;
            return this;
        }

        public Builder withFaceDetectResultListener(FaceDetect.OnDetectResultListener faceDetectResultListener) {
            this.faceDetectResultListener = faceDetectResultListener;
            return this;
        }

        public Builder withImageView(ImageView imageView) {
            this.imageView = imageView;
            return this;
        }

        public Builder withCameraFlashDisabled(boolean disableFlash) {
            this.disableFlash = disableFlash;
            return this;
        }

        public Builder withTimeOut(Long timeInMilliseconds, TimeoutListener listener) {
            this.vouchedCameraHelperTimeout = new VouchedCameraHelperTimeout(timeInMilliseconds, listener);
            return this;
        }

        public VouchedCameraHelperOptions build() {
            return new VouchedCameraHelperOptions(this.cardDetectOptions, this.cardDetectResultListener, this.barcodeDetectResultListener, this.faceDetectOptions, this.faceDetectResultListener, this.vouchedCameraHelperTimeout, this.imageView, this.disableFlash);
        }
    }
}

