/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import id.vouched.android.VouchedCameraHelper;
import id.vouched.android.VouchedLogger;
import id.vouched.android.model.JobResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class IdDetectMgr {
    List<VouchedCameraHelper.Mode> detectModeList = new ArrayList<VouchedCameraHelper.Mode>();
    VouchedCameraHelper.Mode currentMode;

    public IdDetectMgr() {
        this.initDetectModes();
        this.currentMode = this.detectModeList.get(0);
    }

    private void initDetectModes() {
        this.detectModeList.clear();
        this.detectModeList.add(VouchedCameraHelper.Mode.ID);
        this.detectModeList.add(VouchedCameraHelper.Mode.COMPLETED);
    }

    public void addDetectMode(VouchedCameraHelper.Mode detectMode) {
        this.detectModeList.add(detectMode);
        Collections.sort(this.detectModeList);
        VouchedLogger.getInstance().info(String.format("Adding new detection mode: {}", detectMode.toString()));
        VouchedLogger.getInstance().info(String.format("Modes now: {}", this.detectModeList.toString()));
    }

    public VouchedCameraHelper.Mode currentMode() {
        return this.currentMode();
    }

    public boolean hasMode(VouchedCameraHelper.Mode mode) {
        return this.detectModeList.contains((Object)mode);
    }

    public VouchedCameraHelper.Mode nextMode() {
        if (this.currentMode == VouchedCameraHelper.Mode.COMPLETED) {
            return VouchedCameraHelper.Mode.COMPLETED;
        }
        int currIndex = this.detectModeList.indexOf((Object)this.currentMode);
        this.currentMode = this.detectModeList.get(++currIndex);
        return this.currentMode;
    }

    public VouchedCameraHelper.Mode getCurrentMode() {
        return this.currentMode;
    }

    public void reset() {
        this.initDetectModes();
    }

    public void updateIdDetectionModes(JobResult jobResult) {
        if (this.currentMode == VouchedCameraHelper.Mode.ID) {
            if (jobResult.captureBackId() && jobResult.hasPDF417Back() || jobResult.hasPDF417Back()) {
                this.addDetectMode(VouchedCameraHelper.Mode.BARCODE);
            }
            if (jobResult.captureBackId() && !jobResult.hasPDF417Back()) {
                this.addDetectMode(VouchedCameraHelper.Mode.ID_BACK);
            }
        }
    }
}

