/*
 * Decompiled with CFR 0.152.
 */
package id.vouched.android;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.ImageProxy;
import id.vouched.android.BarcodeResult;
import id.vouched.android.FrontBarcodeScanner;
import id.vouched.android.VouchedLogger;
import id.vouched.android.event.SessionEventType;
import id.vouched.android.exception.VouchedAssetsMissingException;
import id.vouched.android.kt.event.SessionEventManager;
import id.vouched.android.mlkit.BitmapUtils;
import id.vouched.android.tflite.Classifier;
import id.vouched.android.utils.IdClassifierUtils;
import java.util.List;
import java9.util.function.Consumer;

public class BarcodeDetect {
    private final OnBarcodeResultListener barcodeResultListener;
    private AssetManager assetManager;

    public BarcodeDetect(AssetManager assetManager, OnBarcodeResultListener barcodeResultListener) {
        this.assetManager = assetManager;
        this.barcodeResultListener = barcodeResultListener;
    }

    public void findBarcode(@NonNull ImageProxy imageProxy, @NonNull Handler handler) {
        Bitmap bitmap = BitmapUtils.getBitmap(imageProxy);
        if (bitmap != null) {
            this.findBarcode(bitmap, handler, (Consumer<Void>)((Consumer)_nada -> imageProxy.close()));
        } else {
            VouchedLogger.getInstance().error("Unable to convert imageProxy to bitmap. Skipping Barcode detection.");
            SessionEventManager.Companion.getInstance().sendEvent(SessionEventType.BarcodeDetectionError);
            imageProxy.close();
        }
    }

    public void findBarcode(@NonNull Bitmap rgbFrameBitmap, @NonNull Handler handler, Consumer<Void> imageCloseFn) {
        handler.post(() -> {
            try {
                List<Classifier.Recognition> detectedIds = IdClassifierUtils.detectIds(rgbFrameBitmap, this.assetManager);
                if (detectedIds.isEmpty()) {
                    this.barcodeResultListener.onBarcodeResult(null);
                    imageCloseFn.accept(null);
                    return;
                }
                if (detectedIds.size() > 1) {
                    this.barcodeResultListener.onBarcodeResult(null);
                    imageCloseFn.accept(null);
                    return;
                }
                FrontBarcodeScanner barcodeScanner = new FrontBarcodeScanner();
                Bitmap detectedIdImage = id.vouched.android.utils.BitmapUtils.clippingBitmap(detectedIds.get(0).getLocation(), rgbFrameBitmap);
                String barcodeText = barcodeScanner.analyzeImageForBarcodes(detectedIdImage, 0);
                if (barcodeText != null && !barcodeText.isEmpty()) {
                    String base64Image = id.vouched.android.utils.BitmapUtils.toBase64(detectedIdImage);
                    this.barcodeResultListener.onBarcodeResult(new BarcodeResult(barcodeText, base64Image));
                    SessionEventManager.Companion.getInstance().sendEvent(SessionEventType.BarcodeDetected);
                } else {
                    this.barcodeResultListener.onBarcodeResult(null);
                }
                imageCloseFn.accept(null);
            }
            catch (VouchedAssetsMissingException e) {
                VouchedLogger.getInstance().error("Skipping barcode detection: " + e.getLocalizedMessage());
                imageCloseFn.accept(null);
                SessionEventManager.Companion.getInstance().sendEvent(SessionEventType.BarcodeDetectionError);
                throw new RuntimeException(e);
            }
        });
    }

    public static interface OnBarcodeResultListener {
        @Nullable
        public void onBarcodeResult(BarcodeResult var1);
    }
}

