/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.prefabs;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGLink;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGRectangle;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGText;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGUnion;
import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;
import hudson.plugins.project_inheritance.util.svg.properties.TextProperty;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;

public class SVGClassBox
extends SVGUnion {
    public SVGClassBox(Point2D.Double pos, TextProperty className, URL classURL, TextProperty bodyText, ColorProperty borders) {
        this(pos, className, classURL, bodyText, borders, null, null);
    }

    public SVGClassBox(Point2D.Double pos, TextProperty className, URL classURL, TextProperty bodyText, ColorProperty borders, Point2D.Double minSize, Point2D.Double maxSize) {
        super(new SVGPrimitive[0]);
        Rectangle2D.Double bounds;
        double yOffset = 0.0;
        int txtMarginX = 2;
        boolean hasClassText = className != null && !className.getText().isEmpty();
        boolean hasBodyText = bodyText != null && !bodyText.getText().isEmpty();
        SVGRectangle svgClassBox = null;
        SVGRectangle svgBodyBox = null;
        if (hasClassText) {
            Point2D.Double txtPos = new Point2D.Double(pos.x + (double)txtMarginX, pos.y);
            SVGText svgClassText = new SVGText(txtPos, className, maxSize != null && maxSize.x > 0.0 ? maxSize.x : 0.0);
            bounds = svgClassText.getBounds();
            bounds.x -= (double)txtMarginX;
            bounds.width += (double)(2 * txtMarginX);
            svgClassBox = new SVGRectangle(bounds, borders, null, hasBodyText ? SVGRectangle.AttachPoints.TOP : SVGRectangle.AttachPoints.HORIZ);
            if (classURL != null) {
                this.addElements(new SVGLink(classURL, new SVGUnion(svgClassText, svgClassBox)));
            } else {
                this.addElements(svgClassText);
                this.addElements(svgClassBox);
            }
            yOffset = svgClassBox.getBounds().getHeight();
        }
        Point2D.Double newPos = new Point2D.Double(pos.x + (double)txtMarginX, pos.y + yOffset);
        if (hasBodyText) {
            SVGText svgBodyText = new SVGText(newPos, bodyText, maxSize != null && maxSize.x > 0.0 ? maxSize.x : 0.0);
            this.addElements(svgBodyText);
            bounds = svgBodyText.getBounds();
            bounds.width *= 1.05;
            if (svgClassBox != null) {
                bounds.width = Math.max(bounds.width, svgClassBox.getBounds().width);
            }
            if (minSize != null) {
                if (minSize.x > 0.0 && bounds.getWidth() < minSize.x) {
                    bounds.width = minSize.x;
                }
                if (minSize.y > 0.0 && bounds.getHeight() < minSize.y) {
                    bounds.height = minSize.y;
                }
            }
            bounds.x -= (double)txtMarginX;
            bounds.width += (double)(2 * txtMarginX);
            svgBodyBox = new SVGRectangle(bounds, borders, null, SVGRectangle.AttachPoints.HORIZ);
            this.addElements(svgBodyBox);
        } else if (minSize != null && minSize.x > 0.0 && minSize.y > 0.0) {
            Rectangle2D.Double bounds2 = new Rectangle2D.Double(newPos.x, newPos.y, minSize.x, minSize.y);
            if (svgClassBox != null) {
                bounds2.width = Math.max(bounds2.width, svgClassBox.getBounds().width);
            }
            svgBodyBox = new SVGRectangle(bounds2, borders, null);
            this.addElements(svgBodyBox);
        }
    }
}

