/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects;

import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.actions.VersioningAction;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterValue;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.util.NodeFileSeparator;
import hudson.plugins.project_inheritance.util.PathMapping;
import hudson.plugins.project_inheritance.util.Resolver;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InheritanceBuild
extends Build<InheritanceProject, InheritanceBuild> {
    private static final Logger LOGGER = Logger.getLogger(InheritanceBuild.class.getName());
    protected transient Map<String, Long> projectVersions;

    public InheritanceBuild(InheritanceProject project) throws IOException {
        super((Project)project);
    }

    public InheritanceBuild(InheritanceProject project, File buildDir) throws IOException {
        super((Project)project, buildDir);
    }

    public synchronized void save() throws IOException {
        super.save();
    }

    public File getRootDir() {
        return super.getRootDir();
    }

    public Map<String, Long> getProjectVersions() {
        VersioningAction verAction;
        if (this.projectVersions == null && (verAction = (VersioningAction)this.getAction(VersioningAction.class)) != null) {
            this.projectVersions = verAction.versionMap;
        }
        return this.projectVersions;
    }

    private void setVersions() {
        VersionHandler.clearVersions();
        Map<String, Long> map = this.getProjectVersions();
        if (map != null) {
            VersionHandler.initVersions(map);
            return;
        }
        map = VersionHandler.initVersions((AbstractProject)this.getParent());
        this.addAction(new VersioningAction(map));
    }

    private void unsetVersions() {
        VersionHandler.clearVersions();
    }

    public static FilePath getWorkspacePathFor(Node n, InheritanceProject project, Map<String, String> values) {
        if (n == null || project == null) {
            return null;
        }
        NodeFileSeparator nfi = NodeFileSeparator.instance;
        String customWorkspace = project.getCustomWorkspace();
        if (customWorkspace != null) {
            customWorkspace = nfi.ensurePathCorrect(n, customWorkspace);
            FilePath root = n.getRootPath();
            return new FilePath(root, customWorkspace);
        }
        String path = project.getParameterizedWorkspace();
        if (path != null && !path.isEmpty()) {
            FilePath root;
            String resolv = Resolver.resolveSingle(values, path);
            if (resolv == null) {
                return null;
            }
            if ((resolv = resolv.trim()).isEmpty()) {
                return null;
            }
            if (!PathMapping.isAbsolute(resolv) && (root = n.getWorkspaceFor((TopLevelItem)project)) != null) {
                root = root.getParent();
                resolv = PathMapping.join(root.getRemote(), resolv);
            }
            resolv = nfi.ensurePathCorrect(n, resolv);
            return new FilePath(n.getChannel(), resolv);
        }
        return n.getWorkspaceFor((TopLevelItem)project);
    }

    public void run() {
        this.setVersions();
        try {
            this.onRun();
        }
        finally {
            this.unsetVersions();
        }
    }

    public void onRun() {
        super.execute((Run.RunExecution)new InheritanceBuildExecution());
    }

    protected class InheritanceBuildExecution
    extends Build.BuildExecution {
        protected InheritanceBuildExecution() {
            super((Build)InheritanceBuild.this);
        }

        protected Result doRun(BuildListener listener) throws Exception {
            Run run = this.getBuild();
            if (!(run instanceof InheritanceBuild)) {
                listener.fatalError("InheritanceBuildExecution was not started by an InheritanceBuild. Versioning and Inheritance can't be trusted.");
                throw new Run.RunnerAbortedException();
            }
            for (ParameterValue pv : this.getParameterValues()) {
                InheritableStringParameterValue ispv;
                if (!(pv instanceof InheritableStringParameterValue) || !(ispv = (InheritableStringParameterValue)pv).getMustHaveValueSet() || ispv.value != null && !ispv.value.isEmpty()) continue;
                listener.fatalError(String.format("Parameter '%s' has no value, but was required to be set. Aborting!", ispv.getName()));
                throw new Run.RunnerAbortedException();
            }
            try {
                return super.doRun(listener);
            }
            catch (InterruptedException e) {
                InheritanceBuild.this.result = Executor.currentExecutor().abortResult();
                listener.getLogger().println(Messages.Run_BuildAborted());
                Executor.currentExecutor().recordCauseOfInterruption(run, (TaskListener)listener);
                LOGGER.log(Level.INFO, run + " aborted");
                return InheritanceBuild.this.result;
            }
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            for (ParameterValue pv : this.getParameterValues()) {
                StringParameterValue spv;
                if (!(pv instanceof StringParameterValue) || !(spv = (StringParameterValue)pv).getName().equalsIgnoreCase("WORKSPACE_REUSE_PATH")) continue;
                return WorkspaceList.Lease.createDummyLease((FilePath)new FilePath(n.getChannel(), spv.value));
            }
            Job job = this.getProject();
            if (job == null && !(job instanceof InheritanceProject)) {
                return super.decideWorkspace(n, wsl);
            }
            InheritanceProject ip = (InheritanceProject)job;
            String customWorkspace = ip.getCustomWorkspace();
            if (customWorkspace != null) {
                return super.decideWorkspace(n, wsl);
            }
            FilePath ws = InheritanceBuild.getWorkspacePathFor(n, ip, (Map<String, String>)((InheritanceBuild)this.getBuild()).getEnvironment((TaskListener)this.getListener()));
            if (ws == null) {
                return super.decideWorkspace(n, wsl);
            }
            return wsl.allocate(ws, (Object)this.getBuild());
        }

        protected Collection<ParameterValue> getParameterValues() {
            HashMap<String, ParameterValue> map = new HashMap<String, ParameterValue>();
            Run run = this.getBuild();
            List actions = run.getActions(ParametersAction.class);
            for (ParametersAction pa : actions) {
                for (ParameterValue pv : pa.getParameters()) {
                    if (pv == null || pv.getName() == null) continue;
                    map.put(pv.getName(), pv);
                }
            }
            return map.values();
        }
    }
}

