/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.primitives;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGLine;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import hudson.plugins.project_inheritance.util.svg.properties.ArrowProperty;
import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGArrow
implements SVGPrimitive {
    protected final SVGLine body;
    protected ArrowProperty head;
    private transient Rectangle2D.Double bounds = null;

    public SVGArrow(SVGLine body, ArrowProperty head) {
        if (body == null) {
            throw new IllegalArgumentException("You may not construct an arrow without a body");
        }
        this.body = body;
        this.head = head;
    }

    public String toString() {
        return String.format("arr[%.2f, %.2f, %.2f, %.2f]", this.body.start.x, this.body.start.y, this.body.end.x, this.body.end.y);
    }

    @Override
    public Element render(Document doc) {
        Element group = doc.createElement("g");
        group.appendChild(this.body.render(doc));
        if (this.head != null) {
            Point2D.Double[] pts = this.head.calcArrowPoints(this.body.start, this.body.end);
            Element hElem = doc.createElement("path");
            hElem.setAttribute("d", String.format("M %f %f L %f %f L %f %f %s %f %f Z", pts[0].x, pts[0].y, this.body.end.x, this.body.end.y, pts[1].x, pts[1].y, this.head.fillHead ? "L" : "M", pts[0].x, pts[0].y));
            hElem.setAttribute("fill", this.head.fillHead ? this.head.stroke.getRGB24Hex() : "none");
            hElem.setAttribute("stroke", this.head.stroke.getRGB24Hex());
            hElem.setAttribute("stroke-width", Double.toString(this.head.stroke.width));
            group.appendChild(hElem);
        }
        return group;
    }

    @Override
    public void translate(Point2D.Double offset) {
        this.body.translate(offset);
        this.bounds = null;
    }

    @Override
    public void moveTo(Point2D.Double pos) {
        this.body.moveTo(pos);
    }

    @Override
    public void rescale(double factor, boolean applyToStyles) {
        this.body.rescale(factor, applyToStyles);
        if (applyToStyles) {
            this.head.stroke.width *= factor;
        }
        this.head.headLen *= factor;
        this.bounds = null;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            Point2D.Double[] pts;
            this.bounds = this.body.getBounds();
            for (Point2D.Double pt : pts = this.head.calcArrowPoints(this.body.start, this.body.end)) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Double(pt.x, pt.y, 0.0, 0.0);
                    continue;
                }
                this.bounds.add(pt);
            }
        }
        return this.bounds;
    }

    @Override
    public List<Point2D.Double> getAttachmentPoints() {
        return this.body.getAttachmentPoints();
    }

    public static SVGArrow createConnection(SVGPrimitive start, SVGPrimitive end, ColorProperty stroke, ArrowProperty head) {
        SVGLine connectorBody = SVGLine.createConnection(start, end, stroke);
        if (connectorBody == null) {
            return null;
        }
        return new SVGArrow(connectorBody, head);
    }
}

