/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.view;

import hudson.ExtensionPoint;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.ParametersAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public abstract class BuildViewExtension
implements ExtensionPoint {
    public String getValuePage() {
        return "value";
    }

    public List<Action> onBuild(AbstractProject<?, ?> project, StaplerRequest req) throws ServletException {
        return Collections.emptyList();
    }

    public static final List<Action> callAll(AbstractProject<?, ?> project, StaplerRequest req) throws ServletException {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (BuildViewExtension ext : Jenkins.get().getExtensionList(BuildViewExtension.class)) {
            actions.addAll(ext.onBuild(project, req));
        }
        BuildViewExtension.mergeParameters(actions);
        return actions;
    }

    public static final void mergeParameters(List<Action> actions) {
        LinkedList pv = new LinkedList();
        Iterator<Action> iter = actions.iterator();
        while (iter.hasNext()) {
            Action a = iter.next();
            if (!(a instanceof ParametersAction)) continue;
            ParametersAction pa = (ParametersAction)a;
            pv.addAll(pa.getParameters());
            iter.remove();
        }
        if (!pv.isEmpty()) {
            actions.add((Action)new ParametersAction(pv));
        }
    }

    public static final JSONObject getSubmittedFormSafely(StaplerRequest req) {
        boolean hasFormContent;
        if (!req.getMethod().equals("POST")) {
            return null;
        }
        Map pMap = req.getParameterMap();
        String cType = req.getContentType();
        boolean bl = hasFormContent = pMap != null && pMap.containsKey("json") || cType != null && cType.startsWith("multipart/");
        if (!hasFormContent) {
            return null;
        }
        try {
            return req.getSubmittedForm();
        }
        catch (ServletException e) {
            return null;
        }
    }
}

