/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.rebuild;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TextParameterDefinition;
import hudson.plugins.project_inheritance.projects.InheritanceBuild;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.rebuild.RebuildParameterFilter;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.util.Reflection;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.util.TimeDuration;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class InheritanceRebuildAction
implements Action {
    private transient InheritanceBuild build;

    public InheritanceProject getProject() {
        return this.getProject(Stapler.getCurrentRequest());
    }

    public InheritanceProject getProject(StaplerRequest request) {
        return InheritanceProject.DESCRIPTOR.getConfiguredProject(request);
    }

    public InheritanceBuild getBuild() {
        if (this.build == null) {
            StaplerRequest req = Stapler.getCurrentRequest();
            return this.getBuild(req);
        }
        return this.build;
    }

    public InheritanceBuild getBuild(StaplerRequest req) {
        if (this.build == null && req != null) {
            this.build = (InheritanceBuild)((Object)req.findAncestorObject(InheritanceBuild.class));
        }
        return this.build;
    }

    private boolean isApplicableFor(InheritanceProject ip) {
        return ip != null && ip.hasPermission(AbstractProject.BUILD) && ip.isBuildable() && !ip.isDisabled();
    }

    public String getIconFileName() {
        InheritanceProject ip = this.getProject();
        if (this.isApplicableFor(ip)) {
            return "clock.gif";
        }
        return null;
    }

    public String getDisplayName() {
        InheritanceProject ip = this.getProject();
        if (this.isApplicableFor(ip)) {
            return "Rebuild";
        }
        return null;
    }

    public String getUrlName() {
        InheritanceProject ip = this.getProject();
        if (this.isApplicableFor(ip)) {
            return "rebuild";
        }
        return null;
    }

    public List<ParameterDefinition> getParametersFor(StaplerRequest request) {
        return this.getParametersFor(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterDefinition> getParametersFor(StaplerRequest request, Boolean showHidden) {
        InheritanceProject ip = this.getProject(request);
        this.build = (InheritanceBuild)((Object)request.findAncestorObject(InheritanceBuild.class));
        if (ip == null || this.build == null) {
            return new LinkedList<ParameterDefinition>();
        }
        Map<String, Long> reqVersions = VersionHandler.getFromRequest();
        Map<String, Long> bldVersions = this.build.getProjectVersions();
        TreeMap<String, Long> versions = new TreeMap<String, Long>();
        if (bldVersions != null) {
            versions.putAll(bldVersions);
        }
        if (reqVersions != null) {
            versions.putAll(reqVersions);
        }
        VersionHandler.initVersions(versions);
        try {
            HashMap<String, ParameterValue> map = new HashMap<String, ParameterValue>();
            ParametersAction action = (ParametersAction)this.build.getAction(ParametersAction.class);
            for (ParameterValue value : action.getParameters()) {
                if (value == null || value.getName() == null || !RebuildParameterFilter.isParameterAllowedByAll(value)) continue;
                map.put(value.getName(), value);
            }
            List<ParameterDefinition> pdLst = ip.getParameters(InheritanceProject.IMode.INHERIT_FORCED);
            LinkedList<Object> modLst = new LinkedList<Object>();
            HashSet<String> handledVars = new HashSet<String>();
            for (ParameterDefinition pd : pdLst) {
                ParameterValue pv;
                if (showHidden != null) {
                    boolean isHidden;
                    Object o = Reflection.invokeIfPossible(pd, "getIsHidden", new Object[0]);
                    boolean bl = isHidden = o != null && o instanceof Boolean && (Boolean)o != false;
                    if (showHidden.booleanValue() && !isHidden || !showHidden.booleanValue() && isHidden) {
                        handledVars.add(pd.getName());
                        continue;
                    }
                }
                if ((pv = (ParameterValue)map.get(pd.getName())) == null) {
                    modLst.add(pd);
                    handledVars.add(pd.getName());
                    continue;
                }
                if (pd instanceof TextParameterDefinition) {
                    Object val = pv.getValue();
                    modLst.add(new TextParameterDefinition(pd.getName(), val instanceof String ? (String)val : val.toString(), pd.getDescription()));
                } else {
                    modLst.add(pd.copyWithDefaultValue(pv));
                }
                handledVars.add(pv.getName());
            }
            if (showHidden != null && showHidden.booleanValue()) {
                for (ParameterValue pv : map.values()) {
                    if (handledVars.contains(pv.getName()) || !(pv instanceof StringParameterValue)) continue;
                    StringParameterValue spv = (StringParameterValue)pv;
                    modLst.add(new StringParameterDefinition(spv.getName(), spv.getValue().toString()));
                }
            }
            Collections.sort(modLst, new Comparator<ParameterDefinition>(){

                @Override
                public int compare(ParameterDefinition o1, ParameterDefinition o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            LinkedList<Object> linkedList = modLst;
            return linkedList;
        }
        finally {
            VersionHandler.clearVersions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, InterruptedException, Descriptor.FormException {
        InheritanceProject ip;
        Map<String, Long> verMap = VersionHandler.getFromFormRequest(req);
        if (verMap == null && (verMap = VersionHandler.getFromProject(this.build.getProject())) == null) {
            verMap = Collections.emptyMap();
        }
        if (req.hasParameter("doRefresh")) {
            String verMapStr = VersionHandler.encodeUrlParameter(verMap);
            String redirURL = String.format("?%s=\"%s\"", "versions", verMapStr);
            rsp.sendRedirect(redirURL);
            return;
        }
        if (!req.hasParameter("doRebuild")) {
            rsp.sendRedirect(".");
        }
        if ((ip = this.getProject(req)) == null) {
            rsp.sendRedirect(req.getContextPath());
            return;
        }
        if (!this.isApplicableFor(ip)) {
            rsp.sendRedirect(ip.getAbsoluteUrl());
            return;
        }
        if (!req.getMethod().equals("POST")) {
            req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        VersionHandler.initVersions(verMap);
        try {
            req.setAttribute("rebuildCause", (Object)this);
            req.setAttribute("rebuildNoRedirect", (Object)true);
            TimeDuration delay = this.build != null ? new TimeDuration((long)((InheritanceProject)this.build.getProject()).getQuietPeriod()) : new TimeDuration(0L);
            ip.doBuild(req, rsp, delay);
            rsp.sendRedirect(ip.getAbsoluteUrl());
        }
        finally {
            VersionHandler.clearVersions();
        }
    }
}

