/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.creation;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.creation.ProjectCreationEngine;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class CreationItemListener
extends ItemListener {
    private static final Logger log = Logger.getLogger(ProjectCreationEngine.class.toString());

    public void onCreated(Item item) {
        if (!(item instanceof InheritanceProject)) {
            return;
        }
        CreationItemListener.pce().notifyProjectNew((InheritanceProject)item);
    }

    public void onRenamed(Item item, String oldName, String newName) {
        if (!(item instanceof InheritanceProject)) {
            return;
        }
        CreationItemListener.pce().notifyProjectChange((InheritanceProject)item);
    }

    public void onUpdated(Item item) {
        if (!(item instanceof InheritanceProject)) {
            return;
        }
        CreationItemListener.pce().notifyProjectChange((InheritanceProject)item);
    }

    public void onDeleted(Item item) {
        if (!(item instanceof InheritanceProject)) {
            return;
        }
        CreationItemListener.pce().notifyProjectDelete((InheritanceProject)item);
    }

    public void onLoaded() {
        CreationItemListener.pce().notifyJenkinsStartupComplete();
        Jenkins.get().rebuildDependencyGraph();
    }

    @Initializer(before=InitMilestone.JOB_LOADED, fatal=false)
    public static void onJenkinsStart() {
        Jenkins j = Jenkins.get();
        int currItems = 0;
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            Map items = j.getItemMap();
            int nextItems = items.size();
            if (nextItems == currItems) break;
            currItems = Math.max(currItems, nextItems);
        }
        if (ProjectCreationEngine.instance != null) {
            ProjectCreationEngine.instance.notifyJenkinsStartupComplete();
        } else {
            log.severe("Issue during loading of transient jobs; PCE not yet initialized!");
        }
    }

    @Initializer(after=InitMilestone.JOB_LOADED, fatal=false)
    public static void onJenkinsJobsGuaranteedLoaded() {
        if (ProjectCreationEngine.instance != null) {
            ProjectCreationEngine.instance.notifyJenkinsStartupComplete();
        } else {
            log.severe("Issue during loading of transient jobs; PCE not yet initialized!");
        }
        Jenkins.get().rebuildDependencyGraph();
    }

    private static ProjectCreationEngine pce() {
        return ProjectCreationEngine.instance;
    }
}

