/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.renderers;

import com.google.common.collect.HashBiMap;
import hudson.plugins.project_inheritance.util.svg.Graph;
import hudson.plugins.project_inheritance.util.svg.SVGNode;
import hudson.plugins.project_inheritance.util.svg.prefabs.SVGClassBox;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGArrow;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import hudson.plugins.project_inheritance.util.svg.properties.ArrowProperty;
import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;
import hudson.plugins.project_inheritance.util.svg.properties.TextProperty;
import hudson.plugins.project_inheritance.util.svg.renderers.SVGGraphRenderer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class SVGTreeRenderer
extends SVGGraphRenderer {
    private static Color[] colors = new Color[]{new Color(0), new Color(11558716), new Color(0xFF4848), new Color(2083658), new Color(9857534), new Color(6466047), new Color(16757800), new Color(14672685)};
    private final double deltaX = 20.0;
    private final double deltaY = 50.0;
    private final double marginX = 10.0;
    private final double marginY = 10.0;

    private static Color getColor(int num) {
        return colors[Math.abs(num) % colors.length];
    }

    public SVGTreeRenderer(Graph<SVGNode> graph, int width, int height) {
        super(graph, width, height);
    }

    @Override
    public Collection<SVGPrimitive> getElements() {
        SVGPrimitive drawable;
        LinkedList<SVGPrimitive> out = new LinkedList<SVGPrimitive>();
        if (this.graph.getNumNodes() <= 0) {
            return out;
        }
        Graph<SVGNode> span = this.graph.getSpanningTree();
        Graph<Object> spanDraw = new Graph<Object>();
        HashBiMap nodeLookup = HashBiMap.create();
        for (SVGNode node : span.getNodes()) {
            drawable = new SVGClassBox(new Point2D.Double(0.0, 0.0), new TextProperty(node.getSVGLabel(), null, TextProperty.STYLE.BOLD, "Consolas", 16, 5), node.getSVGLabelLink(), new TextProperty(node.getSVGDetail(), null, TextProperty.STYLE.PLAIN, "Consolas", 16, 5), new ColorProperty(SVGTreeRenderer.getColor(span.getEdgesFor(node).size()), this.width, 1.0, null), new Point2D.Double(10.0, -1.0), new Point2D.Double(384.0, -1.0));
            spanDraw.addNode(drawable, new SVGPrimitive[0]);
            nodeLookup.put((Object)node, (Object)drawable);
        }
        for (SVGNode node : span.getNodes()) {
            drawable = (SVGPrimitive)nodeLookup.get((Object)node);
            for (SVGNode edge : span.getEdgesFor(node)) {
                spanDraw.addEdges(drawable, (SVGPrimitive)nodeLookup.get((Object)edge));
            }
        }
        LinkedList<Object> open = new LinkedList(spanDraw.getMinimalInboundEdgeNodes(null));
        LinkedList<Object> next = new LinkedList();
        HashMap siblings = new HashMap();
        double xOffset = 10.0;
        double yOffset = 10.0;
        double maxHeight = 0.0;
        while (!open.isEmpty() || !next.isEmpty()) {
            if (open.isEmpty()) {
                xOffset = 10.0;
                yOffset += maxHeight + this.deltaY;
                maxHeight = 0.0;
                LinkedList tmp = open;
                open = next;
                next = tmp;
            }
            SVGPrimitive node = (SVGPrimitive)open.pop();
            node.moveTo(new Point2D.Double(xOffset, yOffset));
            Rectangle2D.Double bounds = node.getBounds();
            if (bounds != null) {
                xOffset += bounds.width + this.deltaX;
                maxHeight = Math.max(bounds.height, maxHeight);
            }
            siblings.put(node, new LinkedList(open));
            next.addAll(spanDraw.getEdgesFor(node));
        }
        boolean hasMoved = true;
        while (hasMoved) {
            hasMoved = false;
            for (Object node : spanDraw.getNodes()) {
                double d;
                Rectangle2D.Double nodeBounds = node.getBounds();
                if (nodeBounds == null) continue;
                RectangularShape childBounds = null;
                for (SVGPrimitive sVGPrimitive : spanDraw.getEdgesFor(node)) {
                    Rectangle2D.Double childBound = sVGPrimitive.getBounds();
                    if (childBound == null) continue;
                    if (childBounds == null) {
                        childBounds = (Rectangle2D.Double)childBound.clone();
                        continue;
                    }
                    Rectangle2D.Double.union((Rectangle2D)childBounds, childBound, (Rectangle2D)childBounds);
                }
                if (childBounds == null || Math.abs(d = nodeBounds.getCenterX() - childBounds.getCenterX()) < 1.0) continue;
                Point2D.Double delta = new Point2D.Double(Math.abs(d), 0.0);
                if (d > 0.0) {
                    HashSet<SVGPrimitive> visitedNodes = new HashSet<SVGPrimitive>();
                    HashSet<Object> openNodes = new HashSet<Object>(spanDraw.getEdgesFor(node));
                    while (!openNodes.isEmpty()) {
                        SVGPrimitive subNode = (SVGPrimitive)openNodes.iterator().next();
                        openNodes.remove(subNode);
                        if (visitedNodes.contains(subNode)) continue;
                        visitedNodes.add(subNode);
                        subNode.translate(delta);
                        openNodes.addAll(spanDraw.getEdgesFor(subNode));
                        openNodes.addAll((Collection)siblings.get(subNode));
                    }
                } else {
                    node.translate(delta);
                    for (SVGPrimitive sibling : (LinkedList)siblings.get(node)) {
                        sibling.translate(delta);
                    }
                }
                hasMoved = true;
            }
        }
        out.addAll(spanDraw.getNodes());
        for (Object node : this.graph.getNodes()) {
            SVGPrimitive dNode = (SVGPrimitive)nodeLookup.get(node);
            for (SVGNode sVGNode : this.graph.getEdgesFor(node)) {
                SVGPrimitive sVGPrimitive = (SVGPrimitive)nodeLookup.get((Object)sVGNode);
                SVGArrow arrow = SVGArrow.createConnection(sVGPrimitive, dNode, new ColorProperty(Color.BLACK, 2.0, 1.0, null), new ArrowProperty(new ColorProperty(Color.BLACK, 2.0, 1.0, null), true, 12.0, 35.0));
                out.addFirst(arrow);
            }
        }
        return out;
    }
}

