/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.parameters;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.queue.ScheduleResult;
import hudson.plugins.project_inheritance.projects.InheritanceBuild;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.actions.VersioningAction;
import hudson.plugins.project_inheritance.projects.inheritance.ParameterSelector;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterDefinition;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterReferenceDefinition;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.projects.view.BuildViewExtension;
import hudson.plugins.project_inheritance.util.Reflection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.OptionalJobProperty;
import jenkins.util.TimeDuration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

public class InheritanceParametersDefinitionProperty
extends ParametersDefinitionProperty {
    public static Comparator<ParameterDefinition> paramComp = new Comparator<ParameterDefinition>(){

        @Override
        public int compare(ParameterDefinition o1, ParameterDefinition o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public InheritanceParametersDefinitionProperty(AbstractProject<?, ?> owner, List<ParameterDefinition> parameterDefinitions) {
        super(InheritanceParametersDefinitionProperty.copySortParameters(parameterDefinitions));
        this.owner = owner;
    }

    public InheritanceParametersDefinitionProperty(AbstractProject<?, ?> owner, ParameterDefinition ... parameterDefinitions) {
        this(owner, Arrays.asList(parameterDefinitions));
    }

    public InheritanceParametersDefinitionProperty(AbstractProject<?, ?> owner, ParametersDefinitionProperty other) {
        this(owner, other.getParameterDefinitions());
    }

    public static final List<ParameterDefinition> copySortParameters(List<ParameterDefinition> in) {
        ArrayList<ParameterDefinition> ret = new ArrayList<ParameterDefinition>(in);
        Collections.sort(ret, paramComp);
        return ret;
    }

    @Deprecated
    public void _doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this._doBuild(req, rsp, this.getDelayFromRequest(req));
    }

    public void _doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        if (!req.getMethod().equals("POST")) {
            req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
        for (Object o : a) {
            ParameterValue parameterValue;
            if (!(o instanceof JSONObject)) continue;
            JSONObject jo = (JSONObject)o;
            String name = jo.getString("name");
            ParameterDefinition d = this.getParameterDefinition(name);
            if (d != null) {
                parameterValue = d.createValue(req, jo);
            } else if (jo.has("value")) {
                parameterValue = new StringParameterValue(name, jo.getString("value"));
            } else {
                throw new IllegalArgumentException("No such parameter definition and also not a string parameter: " + name);
            }
            if (parameterValue == null) continue;
            values.add(parameterValue);
        }
        if (delay == null) {
            delay = new TimeDuration((long)this.getJob().getQuietPeriod());
        }
        CauseAction ca = this.owner instanceof InheritanceProject ? ((InheritanceProject)this.owner).getBuildCauseOverride(req) : new CauseAction((Cause)new Cause.UserIdCause());
        req.getAncestors();
        List<Object> actions = this.owner instanceof AbstractProject ? BuildViewExtension.callAll((AbstractProject)this.owner, req) : Collections.emptyList();
        actions.add(new VersioningAction(VersionHandler.getVersions()));
        actions.add(ca);
        actions.add(new ParametersAction(values));
        BuildViewExtension.mergeParameters(actions);
        ScheduleResult res = Jenkins.get().getQueue().schedule2((Queue.Task)this.owner, delay.getTime(), actions);
        if (req.getAttribute("rebuildNoRedirect") != null) {
            return;
        }
        if (res.isAccepted()) {
            String url = formData.optString("redirectTo");
            if (StringUtils.isEmpty((String)url) || !Util.isSafeToRedirectTo((String)url)) {
                rsp.sendRedirect(".");
            }
            rsp.sendRedirect(formData.optInt("statusCode", 201), url);
        } else {
            rsp.sendRedirect(".");
        }
    }

    @Deprecated
    public void buildWithParameters(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.buildWithParameters(req, rsp, this.getDelayFromRequest(req));
    }

    public void buildWithParameters(StaplerRequest req, StaplerResponse rsp, @CheckForNull TimeDuration delay) throws IOException, ServletException {
        LinkedList<Object> actions = new LinkedList<Object>();
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (ParameterDefinition d : this.getParameterDefinitions()) {
            ParameterValue value = d.createValue(req);
            if (value == null) continue;
            values.add(value);
        }
        actions.add(new ParametersAction(values));
        CauseAction buildCause = null;
        buildCause = this.owner instanceof InheritanceProject ? ((InheritanceProject)this.owner).getBuildCauseOverride(req) : new CauseAction((Cause)new Cause.UserIdCause());
        actions.add(buildCause);
        if (this.owner instanceof AbstractProject) {
            VersioningAction va = new VersioningAction((AbstractProject)this.owner);
            actions.add(va);
        }
        if (delay == null) {
            delay = new TimeDuration((long)this.getJob().getQuietPeriod());
        }
        Jenkins.get().getQueue().schedule2((Queue.Task)this.owner, delay.getTime(), actions);
        if (this.requestWantsJson(req)) {
            rsp.setContentType("application/json");
            rsp.serveExposedBean(req, (Object)this.owner, Flavor.JSON);
        } else {
            rsp.sendRedirect(".");
        }
    }

    private boolean requestWantsJson(StaplerRequest req) {
        String a = req.getHeader("Accept");
        if (a == null) {
            return false;
        }
        return !a.contains("text/html") && a.contains("application/json");
    }

    private TimeDuration getDelayFromRequest(StaplerRequest req) {
        return req.hasParameter("delay") ? TimeDuration.fromString((String)req.getParameter("delay")) : new TimeDuration(0L);
    }

    public static void checkParameterSanity(InheritanceBuild build, BuildListener listener) throws Run.RunnerAbortedException {
        List<ParameterSelector.ScopeEntry> scope = ParameterSelector.instance.getAllScopedParameterDefinitions((InheritanceProject)build.getParent());
        HashMap<String, StringParameterValue> valMap = new HashMap<String, StringParameterValue>();
        for (ParameterValue pv : InheritanceParametersDefinitionProperty.getParameterValues(build)) {
            if (!(pv instanceof StringParameterValue)) continue;
            valMap.put(pv.getName(), (StringParameterValue)pv);
        }
        for (ParameterSelector.ScopeEntry sc : scope) {
            if (!(sc.param instanceof InheritableStringParameterDefinition) || sc.param instanceof InheritableStringParameterReferenceDefinition) continue;
            InheritableStringParameterDefinition scDef = (InheritableStringParameterDefinition)sc.param;
            StringParameterValue val = (StringParameterValue)valMap.get(sc.param.getName());
            if (scDef.getMustBeAssigned() && StringUtils.isEmpty((String)val.getValue().toString())) {
                listener.fatalError(String.format("Parameter '%s' has no value, but was required to be set. Aborting!", val.getName()));
                throw new Run.RunnerAbortedException();
            }
            if (scDef.getInheritanceModeAsVar() != InheritableStringParameterDefinition.IModes.FIXED || StringUtils.equals((String)val.getValue().toString(), (String)scDef.getDefaultValue())) continue;
            listener.fatalError(String.format("Parameter '%s' was fixed in '%s' to the value '%s', but it was overwritten to '%s'. Aborting!", val.getName(), sc.owner, scDef.getDefaultValue(), val.getValue().toString()));
            throw new Run.RunnerAbortedException();
        }
    }

    public static Collection<ParameterValue> getParameterValues(Run<?, ?> run) {
        HashMap<String, ParameterValue> map = new HashMap<String, ParameterValue>();
        List actions = run.getActions(ParametersAction.class);
        for (ParametersAction pa : actions) {
            for (ParameterValue pv : pa.getParameters()) {
                if (pv == null || pv.getName() == null) continue;
                map.put(pv.getName(), pv);
            }
        }
        return map.values();
    }

    public List<ParameterDefinition> getParameterDefinitionSubset(boolean showHidden) {
        LinkedList<ParameterDefinition> out = new LinkedList<ParameterDefinition>();
        for (ParameterDefinition pd : this.getParameterDefinitions()) {
            Object o = Reflection.invokeIfPossible(pd, "getIsHidden", new Object[0]);
            if (o == null || !(o instanceof Boolean)) {
                if (showHidden) continue;
                out.add(pd);
                continue;
            }
            Boolean isHidden = (Boolean)o;
            if (isHidden.booleanValue() && showHidden) {
                out.add(pd);
                continue;
            }
            if (isHidden.booleanValue() || showHidden) continue;
            out.add(pd);
        }
        return out;
    }

    public OptionalJobProperty.OptionalJobPropertyDescriptor getDescriptor() {
        return (OptionalJobProperty.OptionalJobPropertyDescriptor)Jenkins.get().getDescriptorOrDie(ParametersDefinitionProperty.class);
    }

    public static class DescriptorImpl
    extends ParametersDefinitionProperty.DescriptorImpl {
    }
}

