/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects;

import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ReconfigurableDescribable;
import hudson.model.Saveable;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

public class SimplifiedViewDescribableList<T extends Describable<T>, D extends Descriptor<T>>
extends DescribableList<T, Descriptor<T>> {
    public SimplifiedViewDescribableList(Saveable owner, Collection<? extends T> initialList) {
        super(owner, initialList);
    }

    public List<T> rebuildForSimplifiedView(StaplerRequest req, JSONObject json, List<? extends Descriptor<T>> descriptors) throws Descriptor.FormException, IOException {
        ArrayList<Describable> newList = new ArrayList<Describable>();
        for (Descriptor<T> d : descriptors) {
            ReconfigurableDescribable rd;
            Describable existing = this.get(d);
            String name = d.getJsonSafeClassName();
            JSONObject o = json.optJSONObject(name);
            Describable instance = null;
            if (o != null) {
                if (existing instanceof ReconfigurableDescribable) {
                    rd = (ReconfigurableDescribable)existing;
                    instance = rd.reconfigure(req, o);
                } else {
                    instance = d.newInstance(req, o);
                }
            } else if (existing instanceof ReconfigurableDescribable) {
                rd = (ReconfigurableDescribable)existing;
                instance = rd.reconfigure(req, null);
            }
            if (instance == null) continue;
            newList.add(instance);
        }
        return newList;
    }
}

