/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc.provider.impl;

import hu.webarticum.miniconnect.api.MiniResult;
import hu.webarticum.miniconnect.api.MiniSession;
import hu.webarticum.miniconnect.jdbc.provider.DatabaseProvider;
import hu.webarticum.miniconnect.jdbc.provider.ParameterDefinition;
import hu.webarticum.miniconnect.jdbc.provider.ParameterValue;
import hu.webarticum.miniconnect.jdbc.provider.PreparedStatementProvider;
import hu.webarticum.miniconnect.jdbc.provider.impl.PreparedStatementUtil;
import hu.webarticum.miniconnect.lang.ImmutableList;

public class FakePreparedStatementProvider
implements PreparedStatementProvider {
    private final DatabaseProvider databaseProvider;
    private final MiniSession session;
    private final String sql;
    private final String[] sqlParts;
    private final ImmutableList<ParameterDefinition> parameters;
    private final ParameterValue[] parameterValues;

    public FakePreparedStatementProvider(DatabaseProvider databaseProvider, MiniSession session, String sql) {
        this.databaseProvider = databaseProvider;
        this.session = session;
        this.sql = sql;
        this.sqlParts = PreparedStatementUtil.compileSql(sql);
        int parameterCount = this.sqlParts.length - 1;
        this.parameters = ImmutableList.fill((int)parameterCount, i -> new ParameterDefinition());
        this.parameterValues = new ParameterValue[parameterCount];
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public ImmutableList<ParameterDefinition> parameters() {
        return this.parameters;
    }

    @Override
    public void setParameterValue(int zeroBasedIndex, ParameterValue parameterValue) {
        PreparedStatementUtil.closeIfNecessary(this.parameterValues[zeroBasedIndex]);
        this.parameterValues[zeroBasedIndex] = parameterValue;
    }

    @Override
    public void clearParameterValues() {
        for (ParameterValue parameterValue : this.parameterValues) {
            PreparedStatementUtil.closeIfNecessary(parameterValue);
        }
    }

    @Override
    public MiniResult execute() {
        return this.session.execute(this.substitute());
    }

    private String substitute() {
        int expectedParameterCount = this.parameters.size();
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < this.parameterValues.length; ++i) {
            resultBuilder.append(this.sqlParts[i]);
            resultBuilder.append(this.databaseProvider.stringifyValue(this.parameterValues[i]));
        }
        resultBuilder.append(this.sqlParts[expectedParameterCount]);
        return resultBuilder.toString();
    }

    @Override
    public void close() {
    }
}

