/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc.blob;

import hu.webarticum.miniconnect.lang.ByteString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.commons.io.input.BoundedInputStream;

public class WriteableBlob
implements Blob {
    private static final long MAX_MEMORY_SIZE = 10240L;
    private Storage storage;

    public WriteableBlob() {
        this(false);
    }

    public WriteableBlob(boolean forceFileStorage) {
        this.storage = forceFileStorage ? new FileStorage() : new MemoryStorage();
    }

    @Override
    public synchronized long length() throws SQLException {
        return this.storage.length();
    }

    @Override
    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        return this.storage.getBytes(pos, length);
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        return this.storage.getBinaryStream();
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        return this.storage.getBinaryStream(pos, length);
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes) throws SQLException {
        this.ensureStorageForWrite(pos, bytes.length);
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public synchronized int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.ensureStorageForWrite(pos, len);
        return this.storage.setBytes(pos, bytes, offset, len);
    }

    @Override
    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        return new WriteableBlobOutputStream(pos);
    }

    @Override
    public synchronized void truncate(long len) throws SQLException {
        this.storage.truncate(len);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.storage.free();
    }

    private void ensureStorageForWrite(long pos, int len) throws SQLException {
        if (this.storage instanceof FileStorage) {
            return;
        }
        long targetLength = pos - 1L + (long)len;
        if (targetLength <= 10240L) {
            return;
        }
        byte[] content = this.storage.getBytes(1L, (int)this.storage.length());
        FileStorage newStorage = new FileStorage();
        this.storage.setBytes(1L, content, 0, content.length);
        this.storage = newStorage;
    }

    private static class FileStorage
    implements Storage {
        private static final String FILE_ACCESS_MODE = "rw";
        private final File file = FileStorage.createTemporaryFile();
        private final RandomAccessFile randomAccessFile = FileStorage.createRandomAccessFile(this.file);

        private FileStorage() {
        }

        private static File createTemporaryFile() {
            try {
                return Files.createTempFile("miniconnect-jdbc-", ".blob", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static RandomAccessFile createRandomAccessFile(File file) {
            try {
                return new RandomAccessFile(file, FILE_ACCESS_MODE);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public long length() throws SQLException {
            try {
                return this.randomAccessFile.length();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            byte[] result = new byte[length];
            try {
                this.randomAccessFile.seek(pos - 1L);
                this.randomAccessFile.readFully(result);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            return result;
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            long end = pos - 1L + length;
            long fullLength = this.length();
            if (end > fullLength) {
                throw new SQLException(String.format("Out of bounds, requested end: %d, but length is: %d", end, fullLength));
            }
            try {
                this.randomAccessFile.seek(pos - 1L);
                InputStream innerStream = Channels.newInputStream(this.randomAccessFile.getChannel());
                return new BoundedInputStream(innerStream, length);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            try {
                this.randomAccessFile.seek(0L);
                return Channels.newInputStream(this.randomAccessFile.getChannel());
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            try {
                this.randomAccessFile.seek(pos - 1L);
                this.randomAccessFile.write(bytes, offset, len);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            return len;
        }

        @Override
        public void truncate(long len) throws SQLException {
            if (len >= this.length()) {
                return;
            }
            try {
                this.randomAccessFile.setLength(len);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }

        @Override
        public void free() throws SQLException {
            try {
                this.randomAccessFile.close();
                Files.delete(this.file.toPath());
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
    }

    private static class MemoryStorage
    implements Storage {
        private ByteString.Builder content = ByteString.builder();

        private MemoryStorage() {
        }

        @Override
        public long length() throws SQLException {
            return this.content.length();
        }

        @Override
        public byte[] getBytes(long pos, int length) throws SQLException {
            return this.content.build().extractLength(Math.toIntExact(pos - 1L), length);
        }

        @Override
        public InputStream getBinaryStream() throws SQLException {
            return this.content.build().inputStream();
        }

        @Override
        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            return this.content.build().inputStream(Math.toIntExact(pos - 1L), Math.toIntExact(length));
        }

        @Override
        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            long length = this.length();
            if (pos - 1L == length) {
                this.content.append(bytes, offset, len);
                return len;
            }
            if (pos - 1L > length) {
                int padSize = Math.toIntExact(pos - 1L - length);
                this.content.append(new byte[padSize]);
                this.content.append(bytes, offset, len);
                return len;
            }
            ByteString currentByteString = this.content.build();
            ByteString.Builder newContent = ByteString.builder();
            newContent.append(currentByteString, 0, Math.toIntExact(pos - 1L));
            newContent.append(bytes, offset, len);
            long until = pos - 1L + (long)len;
            if (until < length) {
                ByteString tail = currentByteString.substring(Math.toIntExact(until), Math.toIntExact(length));
                newContent.append(tail);
            }
            this.content = newContent;
            return len;
        }

        @Override
        public void truncate(long len) throws SQLException {
            if (len >= this.length()) {
                return;
            }
            ByteString newByteString = this.content.build().substringLength(0, Math.toIntExact(len));
            this.content = ByteString.builder();
            this.content.append(newByteString);
        }

        @Override
        public void free() throws SQLException {
            this.content = ByteString.builder();
        }
    }

    private static interface Storage {
        public long length() throws SQLException;

        public byte[] getBytes(long var1, int var3) throws SQLException;

        public InputStream getBinaryStream() throws SQLException;

        public InputStream getBinaryStream(long var1, long var3) throws SQLException;

        public int setBytes(long var1, byte[] var3, int var4, int var5) throws SQLException;

        public void truncate(long var1) throws SQLException;

        public void free() throws SQLException;
    }

    private class WriteableBlobOutputStream
    extends OutputStream {
        private long oneBasedPosition;

        public WriteableBlobOutputStream(long oneBasedPosition) {
            this.oneBasedPosition = oneBasedPosition;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                WriteableBlob.this.setBytes(this.oneBasedPosition, b, off, len);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.oneBasedPosition += (long)len;
        }
    }
}

