/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.api.MiniError;
import hu.webarticum.miniconnect.api.MiniResult;
import hu.webarticum.miniconnect.jdbc.AbstractJdbcStatement;
import hu.webarticum.miniconnect.jdbc.MiniJdbcConnection;
import hu.webarticum.miniconnect.jdbc.MiniJdbcResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class MiniJdbcStatement
extends AbstractJdbcStatement {
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public MiniJdbcStatement(MiniJdbcConnection connection) {
        super(connection);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        AbstractJdbcStatement.ResultHolder resultHolder = this.executeInternal(sql);
        return resultHolder.jdbcResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.executeInternal(sql);
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        AbstractJdbcStatement.ResultHolder resultHolder = this.executeInternal(sql);
        return resultHolder.result.hasResultSet();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    private AbstractJdbcStatement.ResultHolder executeInternal(String sql) throws SQLException {
        MiniResult result = this.getConnection().getMiniSession().execute(sql);
        if (!result.success()) {
            MiniError error = result.error();
            throw new SQLException(error.message(), error.sqlState(), error.code());
        }
        MiniJdbcResultSet jdbcResultSet = result.hasResultSet() ? new MiniJdbcResultSet(this, result.resultSet()) : null;
        AbstractJdbcStatement.ResultHolder resultHolder = new AbstractJdbcStatement.ResultHolder(result, jdbcResultSet);
        this.handleExecuteCompleted(sql, resultHolder);
        return resultHolder;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closeInternal();
            }
        }
    }

    public void closeInternal() throws SQLException {
        this.closed = true;
        this.getConnection().unregisterActiveStatement(this);
        try {
            ResultSet resultSet = this.getResultSet();
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

