/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.api.MiniColumnHeader;
import hu.webarticum.miniconnect.api.MiniValueDefinition;
import hu.webarticum.miniconnect.lang.ByteString;
import hu.webarticum.miniconnect.lang.ImmutableList;
import hu.webarticum.miniconnect.record.lob.BlobValue;
import hu.webarticum.miniconnect.record.lob.ClobValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MiniJdbcResultSetMetaData
implements ResultSetMetaData {
    private static final Map<String, JDBCType> TYPE_MAPPING = Collections.synchronizedMap(new HashMap());
    private final ImmutableList<MiniColumnHeader> columnHeaders;
    private final ImmutableList<String> columnClassNames;

    public MiniJdbcResultSetMetaData(ImmutableList<MiniColumnHeader> columnHeaders, ImmutableList<String> columnClassNames) {
        this.columnHeaders = columnHeaders;
        this.columnClassNames = columnClassNames;
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (!this.isWrapperFor(type)) {
            throw new SQLException(String.format("Unable to convert %s to %s", this.getClass(), type));
        }
        MiniJdbcResultSetMetaData result = this;
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type != null && type.isAssignableFrom(this.getClass());
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnClassNames.size();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        String columnClassName = this.getColumnClassName(column);
        if (!TYPE_MAPPING.containsKey(columnClassName)) {
            return 2000;
        }
        return TYPE_MAPPING.get(columnClassName).getVendorTypeNumber();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        String columnClassName = this.getColumnClassName(column);
        if (!TYPE_MAPPING.containsKey(columnClassName)) {
            return "JAVA_OBJECT";
        }
        return TYPE_MAPPING.get(columnClassName).getName();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return (String)this.columnClassNames.get(column - 1);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        MiniColumnHeader columnHeader = (MiniColumnHeader)this.columnHeaders.get(column - 1);
        return columnHeader.name();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        MiniColumnHeader columnHeader = (MiniColumnHeader)this.columnHeaders.get(column - 1);
        return columnHeader.isNullable() ? 1 : 0;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumnName(column).equalsIgnoreCase("id");
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        String type = ((MiniColumnHeader)this.columnHeaders.get(column - 1)).valueDefinition().type();
        try {
            return Class.forName(type) == BigDecimal.class;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        String type = ((MiniColumnHeader)this.columnHeaders.get(column - 1)).valueDefinition().type();
        try {
            return Number.class.isAssignableFrom(Class.forName(type));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Class<?> clazz;
        MiniValueDefinition valueDefinition = ((MiniColumnHeader)this.columnHeaders.get(column - 1)).valueDefinition();
        try {
            clazz = Class.forName(valueDefinition.type());
        }
        catch (Exception e) {
            return 0;
        }
        if (clazz == String.class || clazz == ByteString.class || clazz == byte[].class) {
            return Math.max(0, valueDefinition.length());
        }
        if (clazz == Boolean.class || clazz == Byte.class || clazz == Character.class) {
            return 1;
        }
        if (clazz == Short.class) {
            return 5;
        }
        if (clazz == Integer.class) {
            return 10;
        }
        if (clazz == Long.class) {
            return 19;
        }
        if (clazz == Float.class) {
            return 7;
        }
        if (clazz == Double.class) {
            return 15;
        }
        if (clazz == BigInteger.class || clazz == BigDecimal.class) {
            return 30;
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Class<?> clazz;
        MiniValueDefinition valueDefinition = ((MiniColumnHeader)this.columnHeaders.get(column - 1)).valueDefinition();
        try {
            clazz = Class.forName(valueDefinition.type());
        }
        catch (Exception e) {
            return 0;
        }
        if (clazz == BigDecimal.class) {
            return 3;
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return !this.isWritable(column);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return Math.max(((MiniColumnHeader)this.columnHeaders.get(column - 1)).name().length(), this.getPrecision(column));
    }

    static {
        TYPE_MAPPING.put(Void.class.getName(), JDBCType.NULL);
        TYPE_MAPPING.put(Boolean.class.getName(), JDBCType.BOOLEAN);
        TYPE_MAPPING.put(Byte.class.getName(), JDBCType.TINYINT);
        TYPE_MAPPING.put(Short.class.getName(), JDBCType.SMALLINT);
        TYPE_MAPPING.put(Integer.class.getName(), JDBCType.INTEGER);
        TYPE_MAPPING.put(Long.class.getName(), JDBCType.BIGINT);
        TYPE_MAPPING.put(Float.class.getName(), JDBCType.REAL);
        TYPE_MAPPING.put(Double.class.getName(), JDBCType.DOUBLE);
        TYPE_MAPPING.put(BigInteger.class.getName(), JDBCType.NUMERIC);
        TYPE_MAPPING.put(BigDecimal.class.getName(), JDBCType.DECIMAL);
        TYPE_MAPPING.put(ByteString.class.getName(), JDBCType.LONGVARBINARY);
        TYPE_MAPPING.put(byte[].class.getName(), JDBCType.LONGVARBINARY);
        TYPE_MAPPING.put(Character.class.getName(), JDBCType.CHAR);
        TYPE_MAPPING.put(String.class.getName(), JDBCType.LONGVARCHAR);
        TYPE_MAPPING.put(LocalTime.class.getName(), JDBCType.TIME);
        TYPE_MAPPING.put(Time.class.getName(), JDBCType.TIME);
        TYPE_MAPPING.put(LocalDate.class.getName(), JDBCType.DATE);
        TYPE_MAPPING.put(Date.class.getName(), JDBCType.DATE);
        TYPE_MAPPING.put(java.util.Date.class.getName(), JDBCType.DATE);
        TYPE_MAPPING.put(Instant.class.getName(), JDBCType.TIMESTAMP);
        TYPE_MAPPING.put(Timestamp.class.getName(), JDBCType.TIMESTAMP);
        TYPE_MAPPING.put(OffsetTime.class.getName(), JDBCType.TIME_WITH_TIMEZONE);
        TYPE_MAPPING.put(OffsetDateTime.class.getName(), JDBCType.TIMESTAMP_WITH_TIMEZONE);
        TYPE_MAPPING.put(ZonedDateTime.class.getName(), JDBCType.TIMESTAMP_WITH_TIMEZONE);
        TYPE_MAPPING.put(BlobValue.class.getName(), JDBCType.BLOB);
        TYPE_MAPPING.put(ClobValue.class.getName(), JDBCType.CLOB);
    }
}

