/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.jdbc.provider.ParameterDefinition;
import hu.webarticum.miniconnect.lang.ImmutableList;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class MiniJdbcParameterMetaData
implements ParameterMetaData {
    private final ImmutableList<ParameterDefinition> parameters;

    public MiniJdbcParameterMetaData(ImmutableList<ParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (!this.isWrapperFor(type)) {
            throw new SQLException(String.format("Unable to convert %s to %s", this.getClass(), type));
        }
        MiniJdbcParameterMetaData result = this;
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type != null && type.isAssignableFrom(this.getClass());
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameters.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return false;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return 12;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return JDBCType.VARCHAR.getName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return String.class.getName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }
}

