/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.lang.ImmutableMap;
import hu.webarticum.miniconnect.util.ToStringBuilder;
import hu.webarticum.regexbee.Bee;
import hu.webarticum.regexbee.BeeFragment;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionUrlInfo {
    public static final String URL_PREFIX = "jdbc:miniconnect://";
    private static final String HOST_GROUPNAME = "host";
    private static final String PORT_GROUPNAME = "port";
    private static final String SCHEMA_GROUPNAME = "schema";
    private static final String PROPERTIES_GROUPNAME = "properties";
    private static final String KEY_GROUPNAME = "key";
    private static final String VALUE_GROUPNAME = "value";
    private static final Pattern URL_PROPERTY_GROUPED_PATTERN = Bee.then((BeeFragment)Bee.checked((String)"[^&=]+").as("key")).then((BeeFragment)Bee.fixedChar((char)'=')).then(Bee.checked((String)"[^&]*").as("value")).toPattern();
    private static final BeeFragment URL_PROPERTY_FRAGMENT = Bee.then((BeeFragment)Bee.checked((String)"[^&=]+")).then((BeeFragment)Bee.fixedChar((char)'=')).then(Bee.checked((String)"[^&]*"));
    private static final Pattern URL_PATTERN = Bee.then((BeeFragment)Bee.BEGIN).then(Bee.fixed((String)"jdbc:miniconnect://")).then(Bee.checked((String)"[^:/]+").as("host")).then(Bee.fixedChar((char)':').then(Bee.UNSIGNED_INT.as("port"))).then(Bee.fixedChar((char)'/').then(Bee.checked((String)"[^/\\?]+").as("schema")).then(Bee.fixedChar((char)'/').optional()).optional()).then(Bee.fixedChar((char)'?').then(URL_PROPERTY_FRAGMENT.then(Bee.fixedChar((char)'&').then(URL_PROPERTY_FRAGMENT).any()).as("properties").optional()).optional()).then(Bee.END).toPattern();
    private final String host;
    private final int port;
    private final String schema;
    private final ImmutableMap<String, String> properties;

    public static boolean isUrlSupported(String url) {
        return url.startsWith(URL_PREFIX);
    }

    private ConnectionUrlInfo(String host, int port, String schema, ImmutableMap<String, String> properties) {
        this.host = host;
        this.port = port;
        this.schema = schema;
        this.properties = properties;
    }

    public static ConnectionUrlInfo parse(String url) {
        return ConnectionUrlInfo.parse(url, null);
    }

    public static ConnectionUrlInfo parse(String url, Map<?, ?> properties) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid connection url");
        }
        String host = matcher.group(HOST_GROUPNAME);
        int port = Integer.parseInt(matcher.group(PORT_GROUPNAME));
        String schema = matcher.group(SCHEMA_GROUPNAME);
        String propertiesPart = matcher.group(PROPERTIES_GROUPNAME);
        HashMap<String, String> propertiesBuilder = new HashMap<String, String>();
        if (properties != null) {
            properties.forEach((k, v) -> propertiesBuilder.put(k.toString(), v.toString()));
        }
        if (propertiesPart != null) {
            Matcher propertyMatcher = URL_PROPERTY_GROUPED_PATTERN.matcher(propertiesPart);
            while (propertyMatcher.find()) {
                String key = URLDecoder.decode(propertyMatcher.group(KEY_GROUPNAME), StandardCharsets.UTF_8);
                String value = URLDecoder.decode(propertyMatcher.group(VALUE_GROUPNAME), StandardCharsets.UTF_8);
                propertiesBuilder.put(key, value);
            }
        }
        return new ConnectionUrlInfo(host, port, schema, (ImmutableMap<String, String>)ImmutableMap.fromMap(propertiesBuilder));
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String schema() {
        return this.schema;
    }

    public ImmutableMap<String, String> properties() {
        return this.properties;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).add(HOST_GROUPNAME, (Object)this.host).add(PORT_GROUPNAME, (Object)this.port).add(SCHEMA_GROUPNAME, (Object)this.schema).add(PROPERTIES_GROUPNAME, this.properties).build();
    }
}

