/*
 * Decompiled with CFR 0.152.
 */
package hu.kole.cleversectionviewadapter.draganddrop;

import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.DragEvent;
import android.view.View;
import hu.kole.cleversectionviewadapter.BaseCleverSectionAdapter;
import hu.kole.cleversectionviewadapter.draganddrop.DragInfo;
import java.lang.ref.WeakReference;

public class DragManager
implements View.OnDragListener {
    private final WeakReference<RecyclerView> recyclerViewRef;
    private final BaseCleverSectionAdapter<?, ?, ?, ?, ?> adapter;
    private long draggingId = -1L;
    private final PointF nextMoveTouchPoint = new PointF(Float.MIN_VALUE, Float.MIN_VALUE);
    @Nullable
    private DragInfo lastDragInfo;

    public DragManager(RecyclerView recyclerView, BaseCleverSectionAdapter<?, ?, ?, ?, ?> adapter) {
        this.recyclerViewRef = new WeakReference<RecyclerView>(recyclerView);
        this.adapter = adapter;
    }

    public boolean onDrag(View v, DragEvent event) {
        if (v != this.recyclerViewRef.get() || !(event.getLocalState() instanceof DragInfo)) {
            return false;
        }
        final RecyclerView recyclerView = (RecyclerView)v;
        DragInfo dragInfo = (DragInfo)event.getLocalState();
        final long itemId = dragInfo.itemId();
        switch (event.getAction()) {
            case 1: {
                this.draggingId = itemId;
                this.adapter.notifyItemChanged(this.adapter.getPositionForId((int)itemId));
                break;
            }
            case 2: {
                float x = event.getX();
                float y = event.getY();
                int fromPosition = this.adapter.getPositionForId((int)itemId);
                int toPosition = -1;
                View child = recyclerView.findChildViewUnder(event.getX(), event.getY());
                if (child != null) {
                    toPosition = recyclerView.getChildViewHolder(child).getAdapterPosition();
                }
                if (toPosition >= 0 && fromPosition != toPosition) {
                    RecyclerView.ItemAnimator animator = recyclerView.getItemAnimator();
                    boolean scheduleNextMove = this.nextMoveTouchPoint.equals(Float.MIN_VALUE, Float.MIN_VALUE);
                    this.nextMoveTouchPoint.set(x, y);
                    if (scheduleNextMove) {
                        animator.isRunning(new RecyclerView.ItemAnimator.ItemAnimatorFinishedListener(){

                            public void onAnimationsFinished() {
                                if (DragManager.this.nextMoveTouchPoint.equals(Float.MIN_VALUE, Float.MIN_VALUE)) {
                                    return;
                                }
                                final int fromPosition = DragManager.this.adapter.getPositionForId((int)itemId);
                                View child = recyclerView.findChildViewUnder(((DragManager)DragManager.this).nextMoveTouchPoint.x, ((DragManager)DragManager.this).nextMoveTouchPoint.y);
                                if (child != null) {
                                    final int toPosition = recyclerView.getChildViewHolder(child).getAdapterPosition();
                                    if (DragManager.this.adapter.move(fromPosition, toPosition)) {
                                        if (fromPosition == 0 || toPosition == 0) {
                                            recyclerView.scrollToPosition(0);
                                        }
                                        recyclerView.post(new Runnable(){

                                            @Override
                                            public void run() {
                                                DragManager.this.adapter.notifyItemMoved(fromPosition, toPosition);
                                            }
                                        });
                                    }
                                }
                                DragManager.this.clearNextMove();
                            }
                        });
                    }
                }
                this.lastDragInfo = dragInfo;
                this.lastDragInfo.setDragPoint(x, y);
                this.adapter.handleDragScroll(recyclerView, dragInfo);
                break;
            }
            case 4: {
                this.draggingId = -1L;
                this.lastDragInfo = null;
                recyclerView.getItemAnimator().isRunning(new RecyclerView.ItemAnimator.ItemAnimatorFinishedListener(){

                    public void onAnimationsFinished() {
                        int position = DragManager.this.adapter.getPositionForId((int)itemId);
                        RecyclerView.ViewHolder vh = recyclerView.findViewHolderForItemId(itemId);
                        if (vh != null && vh.getAdapterPosition() != position) {
                            recyclerView.post(new Runnable(){

                                @Override
                                public void run() {
                                    recyclerView.getItemAnimator().isRunning(new RecyclerView.ItemAnimator.ItemAnimatorFinishedListener(){

                                        public void onAnimationsFinished() {
                                            DragManager.this.adapter.notifyItemChanged(DragManager.this.adapter.getPositionForId((int)itemId));
                                        }
                                    });
                                }
                            });
                        } else {
                            DragManager.this.adapter.notifyItemChanged(DragManager.this.adapter.getPositionForId((int)itemId));
                        }
                    }
                });
                break;
            }
            case 3: {
                this.adapter.onDrop();
                break;
            }
            case 5: {
                break;
            }
        }
        return true;
    }

    public void clearNextMove() {
        this.nextMoveTouchPoint.set(Float.MIN_VALUE, Float.MIN_VALUE);
    }

    public long getDraggingId() {
        return this.draggingId;
    }

    @Nullable
    public DragInfo getLastDragInfo() {
        return this.lastDragInfo;
    }
}

