/*
 * Decompiled with CFR 0.152.
 */
package hu.kole.cleversectionviewadapter.model;

import hu.kole.cleversectionviewadapter.model.BaseSectionItemModel;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSectionModel
implements Cloneable {
    protected boolean isHeaderVisible = true;
    protected boolean isFooterVisible = true;

    public boolean isHeaderVisible() {
        return this.isHeaderVisible;
    }

    public boolean isFooterVisible() {
        return this.isFooterVisible;
    }

    public abstract String getId();

    public abstract <T extends BaseSectionItemModel> List<T> getSectionItems();

    public abstract <T extends BaseSectionItemModel> void setSectionItems(List<T> var1);

    public int getSectionItemCount() {
        return this.getSectionItems().size();
    }

    public boolean equals(BaseSectionModel model) {
        return this.getId().equalsIgnoreCase(model.getId());
    }

    public Object clone() {
        try {
            BaseSectionModel model = (BaseSectionModel)super.clone();
            model.setSectionItems(new ArrayList(model.getSectionItems()));
            return model;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public <T extends BaseSectionItemModel> int getItemIndexInSection(T rowItem) {
        int pos = 0;
        for (BaseSectionItemModel item : this.getSectionItems()) {
            if (item.equals(rowItem)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public final <T extends BaseSectionItemModel> boolean isHeaderItemAtFirstPosition() {
        List<T> sectionItems = this.getSectionItems();
        if (sectionItems.size() > 0) {
            return ((BaseSectionItemModel)sectionItems.get(0)).getViewType() == -10000;
        }
        return false;
    }

    public final <T extends BaseSectionItemModel> boolean isFooterItemAtLastPosition() {
        List<T> sectionItems = this.getSectionItems();
        if (sectionItems.size() > 0) {
            int lastIndex = sectionItems.size() - 1;
            return ((BaseSectionItemModel)sectionItems.get(lastIndex)).getViewType() == -20000;
        }
        return false;
    }
}

