/*
 * Decompiled with CFR 0.152.
 */
package hu.kole.cleversectionviewadapter.listeners;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import hu.kole.cleversectionviewadapter.BaseCleverSectionAdapter;

public abstract class EndlessScrollListener
extends RecyclerView.OnScrollListener {
    private int visibleThreshold = 3;
    private int currentPage = 0;
    private int previousTotalItemCount = 0;
    private boolean loading = true;
    private int startingPageIndex = 0;
    private LinearLayoutManager mLinearLayoutManager;
    private BaseCleverSectionAdapter mAdapter;
    private boolean isProgressNeeded = false;
    private boolean isEndlessScrollEnabled = true;

    public EndlessScrollListener(LinearLayoutManager layoutManager, BaseCleverSectionAdapter adapter, boolean isProgressNeeded) {
        this.mLinearLayoutManager = layoutManager;
        this.mAdapter = adapter;
        this.isProgressNeeded = isProgressNeeded;
    }

    public void onScrolled(RecyclerView view, int dx, int dy) {
        int firstVisibleItem = this.mLinearLayoutManager.findFirstVisibleItemPosition();
        int visibleItemCount = view.getChildCount();
        int totalItemCount = this.mLinearLayoutManager.getItemCount();
        if (totalItemCount < this.previousTotalItemCount) {
            this.currentPage = this.startingPageIndex;
            this.previousTotalItemCount = totalItemCount;
            if (totalItemCount == 0) {
                this.loading = true;
            }
        }
        if (this.loading && totalItemCount > this.previousTotalItemCount) {
            this.loading = false;
            this.previousTotalItemCount = totalItemCount;
        }
        if (!this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + this.visibleThreshold && this.isEndlessScrollEnabled) {
            ++this.currentPage;
            this.loading = true;
            if (this.isProgressNeeded) {
                this.mAdapter.addShowMoreProgress();
                this.previousTotalItemCount = this.mLinearLayoutManager.getItemCount();
            }
            this.onLoadMore(this.currentPage, totalItemCount);
        }
    }

    public abstract void onLoadMore(int var1, int var2);

    public void setEndlessScrollEnabled(boolean isEnabled) {
        this.isEndlessScrollEnabled = isEnabled;
    }
}

