/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.roaster.oracle.service;

import hu.icellmobilsoft.coffee.dto.exception.BONotFoundException;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.common.FunctionalInterfaces;
import hu.icellmobilsoft.roaster.oracle.connection.JDBCConnection;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import org.apache.commons.lang3.StringUtils;

@Dependent
public class OracleJDBCSelectorService {
    private static final String ERROR_MSG_ERROR_OCCURRED_DURING_DB_CONNECTION = "Error occurred during DB connection!";
    private static final String ERROR_MSG_ENTITY_NOT_FOUND = "Entity not found!";
    private static final String ERROR_MSG_SQL_STRING_IS_BLANK = "Input parameter SQL string is blank!";
    private static final String ERROR_MSG_COLUMN_NAME_IS_BLANK = "Input parameter columnName is blank!";
    private static final String ERROR_MSG_CONVERTER_IS_NULL = "Input parameter converter is null!";
    private static final String ERROR_MSG_COULD_NOT_RETRIEVE_COLUMN_VALUE = "Could not retrieve column [{0}] value!";
    private final Logger log = Logger.getLogger(OracleJDBCSelectorService.class);
    private JDBCConnection jdbcConnection;

    public String selectFirstStringValue(String sql, String columnName) throws BaseException {
        return (String)this.getFirstValue(sql, columnName, this::getStringColumnValue);
    }

    public Integer selectFirstIntegerValue(String sql, String columnName) throws BaseException {
        return (Integer)this.getFirstValue(sql, columnName, this::getIntegerColumnValue);
    }

    public Boolean selectFirstBooleanValue(String sql, String columnName) throws BaseException {
        return (Boolean)this.getFirstValue(sql, columnName, this::getBooleanColumnValue);
    }

    public BigDecimal selectFirstBigDecimalValue(String sql, String columnName) throws BaseException {
        return (BigDecimal)this.getFirstValue(sql, columnName, this::getBigDecimalColumnValue);
    }

    public Date selectFirstDateValue(String sql, String columnName) throws BaseException {
        return (Date)this.getFirstValue(sql, columnName, this::getDateColumnValue);
    }

    /*
     * Exception decompiling
     */
    public Integer selectRowCount(String sql) throws BaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T selectFirstObject(String sql, FunctionalInterfaces.BaseExceptionFunction<ResultSet, T> converter) throws BaseException {
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, ERROR_MSG_SQL_STRING_IS_BLANK);
        }
        if (Objects.isNull(converter)) {
            throw new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, ERROR_MSG_CONVERTER_IS_NULL);
        }
        try (Connection connection = this.jdbcConnection.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (!rs.next()) throw new BONotFoundException(ERROR_MSG_ENTITY_NOT_FOUND);
            Object object = converter.apply((Object)rs);
            return (T)object;
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, ERROR_MSG_ERROR_OCCURRED_DURING_DB_CONNECTION, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> List<T> selectAllObjects(String sql, FunctionalInterfaces.BaseExceptionFunction<ResultSet, T> converter) throws BaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getFirstValue(String sql, String columnName, FunctionalInterfaces.BaseExceptionFunction2<ResultSet, String, T> function) throws BaseException {
        if (StringUtils.isBlank((CharSequence)sql)) {
            throw new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, ERROR_MSG_SQL_STRING_IS_BLANK);
        }
        if (StringUtils.isBlank((CharSequence)columnName)) {
            throw new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, ERROR_MSG_COLUMN_NAME_IS_BLANK);
        }
        try (Connection connection = this.jdbcConnection.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (!rs.next()) throw new BONotFoundException(ERROR_MSG_ENTITY_NOT_FOUND);
            Object object = function.apply((Object)rs, (Object)columnName);
            return (T)object;
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, ERROR_MSG_ERROR_OCCURRED_DURING_DB_CONNECTION, (Throwable)e);
        }
    }

    private String getStringColumnValue(ResultSet rs, String columnName) throws BaseException {
        try {
            return rs.getString(columnName);
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format(ERROR_MSG_COULD_NOT_RETRIEVE_COLUMN_VALUE, columnName), (Throwable)e);
        }
    }

    private Integer getIntegerColumnValue(ResultSet rs, String columnName) throws BaseException {
        try {
            return rs.getInt(columnName);
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format(ERROR_MSG_COULD_NOT_RETRIEVE_COLUMN_VALUE, columnName), (Throwable)e);
        }
    }

    private BigDecimal getBigDecimalColumnValue(ResultSet rs, String columnName) throws BaseException {
        try {
            return rs.getBigDecimal(columnName);
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format(ERROR_MSG_COULD_NOT_RETRIEVE_COLUMN_VALUE, columnName), (Throwable)e);
        }
    }

    private Boolean getBooleanColumnValue(ResultSet rs, String columnName) throws BaseException {
        try {
            return rs.getBoolean(columnName);
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format(ERROR_MSG_COULD_NOT_RETRIEVE_COLUMN_VALUE, columnName), (Throwable)e);
        }
    }

    private Date getDateColumnValue(ResultSet rs, String columnName) throws BaseException {
        try {
            return rs.getDate(columnName);
        }
        catch (SQLException e) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, MessageFormat.format(ERROR_MSG_COULD_NOT_RETRIEVE_COLUMN_VALUE, columnName), (Throwable)e);
        }
    }

    protected JDBCConnection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public void setJdbcConnection(JDBCConnection jdbcConnection) {
        this.jdbcConnection = jdbcConnection;
    }
}

