/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.roaster.oracle.producer;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.annotation.AnnotationUtil;
import hu.icellmobilsoft.roaster.oracle.annotation.DBConnection;
import hu.icellmobilsoft.roaster.oracle.connection.JDBCConnection;
import hu.icellmobilsoft.roaster.oracle.service.OracleJDBCSelectorService;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class OracleJDBCServiceProducer {
    private final Logger log = Logger.getLogger(OracleJDBCServiceProducer.class);

    @Dependent
    @Produces
    @DBConnection(configKey="")
    public OracleJDBCSelectorService getOracleJDBCSelectorService(InjectionPoint injectionPoint) throws BaseException {
        Optional annotation = AnnotationUtil.getAnnotation((InjectionPoint)injectionPoint, DBConnection.class);
        String configKey = annotation.map(DBConnection::configKey).orElseThrow(() -> new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, "configKey value not found!"));
        JDBCConnection connection = (JDBCConnection)CDI.current().select(JDBCConnection.class, new Annotation[]{new DBConnection.Literal(configKey)}).get();
        if (connection != null) {
            this.log.trace("Creating OracleJDBCSelectorService...");
            OracleJDBCSelectorService oracleJDBCSelectorService = (OracleJDBCSelectorService)CDI.current().select(OracleJDBCSelectorService.class, new Annotation[0]).get();
            oracleJDBCSelectorService.setJdbcConnection(connection);
            return oracleJDBCSelectorService;
        }
        throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, MessageFormat.format("Error occurred while creating OracleJDBCSelectorService for configKey [{0}]!", configKey));
    }

    public void returnResource(@Disposes @DBConnection(configKey="") OracleJDBCSelectorService oracleJDBCSelectorService) {
        if (oracleJDBCSelectorService != null) {
            this.log.trace("Closing OracleJDBCSelectorService...");
        }
    }
}

