/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.roaster.oracle.producer;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.coffee.tool.utils.annotation.AnnotationUtil;
import hu.icellmobilsoft.roaster.oracle.annotation.DBConnection;
import hu.icellmobilsoft.roaster.oracle.config.ManagedDBConfig;
import hu.icellmobilsoft.roaster.oracle.connection.JDBCConnection;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;

@ApplicationScoped
public class DBConnectionProducer {
    private final Logger log = Logger.getLogger(DBConnectionProducer.class);
    private final Map<String, JDBCConnection> connectionInstances = new HashMap<String, JDBCConnection>();

    @Produces
    @Dependent
    @DBConnection(configKey="")
    public JDBCConnection getConnection(InjectionPoint injectionPoint) throws BaseException {
        Optional annotation = AnnotationUtil.getAnnotation((InjectionPoint)injectionPoint, DBConnection.class);
        String configKey = annotation.map(DBConnection::configKey).orElseThrow(() -> new BaseException((Enum)CoffeeFaultType.INVALID_INPUT, "configKey value not found!"));
        return this.getInstance(configKey);
    }

    private synchronized JDBCConnection getInstance(String configKey) {
        return this.connectionInstances.compute(configKey, this::getJdbcConnection);
    }

    private JDBCConnection getJdbcConnection(String configKey, JDBCConnection existingConnection) {
        return existingConnection == null || existingConnection.isClosed() ? this.createConnection(configKey) : existingConnection;
    }

    private JDBCConnection createConnection(String configKey) {
        try {
            this.log.info("Creating DB connection for configKey: [{0}]", new Object[]{configKey});
            ManagedDBConfig managedDBConfig = (ManagedDBConfig)CDI.current().select(ManagedDBConfig.class, new Annotation[]{new DBConnection.Literal(configKey)}).get();
            this.log.info("DB connection url [{0}], user: [{1}]", new Object[]{managedDBConfig.getUrl(), managedDBConfig.getUser()});
            return ((JDBCConnection)CDI.current().select(JDBCConnection.class, new Annotation[0]).get()).withConfig(managedDBConfig);
        }
        catch (Exception e) {
            this.log.error(MessageFormat.format("Exception on initializing DB connection for configKey: [{0}], [{1}]", configKey, e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    @PreDestroy
    public void clear() {
        this.log.trace("Closing open connections...");
        for (JDBCConnection connection : this.connectionInstances.values()) {
            connection.close();
        }
        this.connectionInstances.clear();
    }
}

