/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.roaster.oracle.connection;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.dto.exception.TechnicalException;
import hu.icellmobilsoft.coffee.dto.exception.enums.CoffeeFaultType;
import hu.icellmobilsoft.coffee.se.logging.Logger;
import hu.icellmobilsoft.roaster.oracle.config.ManagedDBConfig;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Objects;
import javax.enterprise.context.Dependent;

@Dependent
public class JDBCConnection
implements Closeable {
    private static final String ERROR_MSG_ERROR_OCCURRED_DURING_DB_CONNECTION = "Error occurred during DB connection! [{0}]";
    private static final String ERROR_MSG_DB_CONFIGURATION_NOT_SET = "DB configuration not set!";
    private final Logger log = Logger.getLogger(JDBCConnection.class);
    private ManagedDBConfig config;
    private HikariDataSource dataSource;

    public Connection getConnection() throws BaseException {
        this.initIfNeeded();
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            String errorMsg = MessageFormat.format(ERROR_MSG_ERROR_OCCURRED_DURING_DB_CONNECTION, e.getLocalizedMessage());
            this.log.error(errorMsg);
            throw new TechnicalException((Enum)CoffeeFaultType.REPOSITORY_FAILED, errorMsg, (Throwable)e);
        }
    }

    private void initIfNeeded() throws TechnicalException {
        if (Objects.isNull(this.config)) {
            throw new TechnicalException((Enum)CoffeeFaultType.OPERATION_FAILED, ERROR_MSG_DB_CONFIGURATION_NOT_SET);
        }
        if (this.dataSource == null) {
            this.log.trace("Creating dataSource. Url: [{0}], user: [{1}]", new Object[]{this.config.getUrl(), this.config.getUser()});
            this.dataSource = this.createDataSource();
        }
    }

    private HikariDataSource createDataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.config.getUrl());
        hikariConfig.setUsername(this.config.getUser());
        hikariConfig.setPassword(this.config.getPassword());
        hikariConfig.setMaximumPoolSize(this.config.getMaximumPoolSize());
        return new HikariDataSource(hikariConfig);
    }

    public JDBCConnection withConfig(ManagedDBConfig config) {
        this.config = config;
        return this;
    }

    public boolean isClosed() {
        if (Objects.isNull(this.dataSource)) {
            return true;
        }
        return this.dataSource.isClosed();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.log.trace("Closing dataSource...");
            this.dataSource.close();
        }
    }
}

