/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.roaster.oracle.config;

import hu.icellmobilsoft.roaster.oracle.config.DBConfig;
import hu.icellmobilsoft.roaster.oracle.constatns.DBTypeEnum;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;

@Dependent
public class ManagedDBConfig
implements DBConfig {
    public static final String DB_PREFIX = "roaster.datasource";
    public static final String URL = "url";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String MAXIMUM_POOL_SIZE = "maximumPoolSize";
    public static final String KEY_DELIMITER = ".";
    @Inject
    private Config config;
    private String configKey;

    @Override
    public String getUrl() {
        return this.config.getOptionalValue(this.joinKey(URL), String.class).orElse("localhost");
    }

    @Override
    public String getUser() {
        return this.config.getOptionalValue(this.joinKey(USER), String.class).orElse("admin");
    }

    @Override
    public String getPassword() {
        return this.config.getOptionalValue(this.joinKey(PASSWORD), String.class).orElse(null);
    }

    @Override
    public int getMaximumPoolSize() {
        return this.config.getOptionalValue(this.joinKey(MAXIMUM_POOL_SIZE), Integer.class).orElse(5);
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    private String joinKey(String key) {
        return String.join((CharSequence)KEY_DELIMITER, DB_PREFIX, DBTypeEnum.ORACLE.value(), this.configKey, key);
    }
}

