/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.spg.processor.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import ru.noties.spg.processor.Logger;
import ru.noties.spg.processor.data.DefItem;
import ru.noties.spg.processor.data.KeyHolder;
import ru.noties.spg.processor.data.KeyType;
import ru.noties.spg.processor.data.PreferenceHolder;
import ru.noties.spg.processor.data.SerializerHolder;
import ru.noties.spg.processor.writer.Indent;
import ru.noties.spg.processor.writer.MethodNameUtils;

public class SPGPreferenceWriter
implements Logger {
    private static final char SEMICOLON = ';';
    private static final String[] INITIAL_IMPORTS = new String[]{"ru.noties.spg.*;", "android.content.*;", "java.util.*", "android.preference.PreferenceManager"};
    private static final String GEN_INFO_PATTERN = "// This file is generated by SharedPreferencesGenerator library at %s\n// The description for this preference was taken from: %s\n// Do not modify this file\n\n";
    private static final String CLASS_STATEMENT_PATTERN = "public class %s implements SPGPreferenceObject%s {\n\n";
    private static final String ENTITY_INTERFACE_PATTERN = ", SPGPreferenceEntity<%s>";
    private static final String CONST_PREF_NAME = "PREFERENCE_NAME";
    private static final String CONST_PREF_MODE = "PREFERENCE_MODE";
    private static final String CONST_KEY = "KEY_";
    private static final String CONST_DEF = "DEF_";
    private static final String CONST_MODIFIERS = "public static final ";
    private final Logger mLogger;
    private final Elements mElements;
    private final Filer mFiler;

    public SPGPreferenceWriter(Logger logger, Elements elements, Filer filer) {
        this.mLogger = logger;
        this.mElements = elements;
        this.mFiler = filer;
    }

    @Override
    public void log(Diagnostic.Kind level, String message, Object ... args) {
        this.mLogger.log(level, message, args);
    }

    public void write(PreferenceHolder preference) {
        TypeElement element = preference.typeElement;
        String entityClassName = SPGPreferenceWriter.createQualifiedName(element);
        String prefPackage = this.mElements.getPackageOf(element).toString();
        String prefClassName = SPGPreferenceWriter.createClassName(element);
        this.log(Diagnostic.Kind.NOTE, "Writing @SPGPreference: `%s` to a file: `%s.%s.java`", element, prefPackage, prefClassName);
        Indent indent = new Indent();
        StringBuilder builder = new StringBuilder();
        builder.append(SPGPreferenceWriter.semicolon(SPGPreferenceWriter.createPackageStatement(prefPackage))).append("\n\n");
        SPGPreferenceWriter.writeImports(builder, preference.imports);
        SPGPreferenceWriter.writeGenInfo(builder, element);
        SPGPreferenceWriter.writeClassStatement(builder, prefClassName, preference.toEntity ? entityClassName : null);
        indent.increment();
        SPGPreferenceWriter.writeConstants(builder, indent, preference);
        this.writeGetInstanceStatement(builder, indent, preference, prefClassName);
        SPGPreferenceWriter.writeLocalVariables(builder, indent);
        SPGPreferenceWriter.writeConstructor(builder, indent, prefClassName, preference.defaultName, preference.preferenceMode);
        SPGPreferenceWriter.writeGetters(builder, indent, preference.keys);
        SPGPreferenceWriter.writeSetters(builder, indent, preference);
        SPGPreferenceWriter.writeSPGObjectMethods(builder, indent, preference);
        SPGPreferenceWriter.writeSetterClass(builder, indent, preference);
        SPGPreferenceWriter.writeOnUpdate(builder, indent, preference);
        builder.append("}");
        Writer writer = null;
        try {
            JavaFileObject fileObject = this.mFiler.createSourceFile(prefPackage + "." + prefClassName, new Element[0]);
            writer = fileObject.openWriter();
            writer.write(builder.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeConstants(StringBuilder builder, Indent indent, PreferenceHolder preference) {
        String prefName = SPGPreferenceWriter.createConstantStatement(KeyType.STRING, CONST_PREF_NAME, "\"" + preference.name + "\"");
        String prefMode = SPGPreferenceWriter.createConstantStatement(KeyType.INT, CONST_PREF_MODE, String.valueOf(preference.preferenceMode));
        builder.append(indent).append(prefName).append("\n").append(indent).append(prefMode).append("\n\n");
        Map<KeyType, DefItem> defs = preference.defaults.defs;
        for (Map.Entry<KeyType, DefItem> e : defs.entrySet()) {
            KeyType keyType = e.getKey();
            DefItem defItem = e.getValue();
            String value = keyType == KeyType.STRING && !defItem.isEvaluation ? "\"" + defItem.value + "\"" : defItem.value;
            builder.append(indent).append(SPGPreferenceWriter.createConstantStatement(keyType, SPGPreferenceWriter.createDefName(keyType), value)).append("\n");
        }
        builder.append('\n');
        List<KeyHolder> keys = preference.keys;
        for (KeyHolder key : keys) {
            builder.append(indent).append(SPGPreferenceWriter.createConstantStatement(KeyType.STRING, SPGPreferenceWriter.createConstantStatementName(CONST_KEY, key.fieldName), "\"" + key.name + "\"")).append('\n');
        }
        builder.append('\n');
    }

    private void writeGetInstanceStatement(StringBuilder builder, Indent indent, PreferenceHolder preference, String className) {
        if (preference.isSingleton) {
            SPGPreferenceWriter.writeSingletonGetInstance(builder, indent, className);
        }
    }

    private static void writeSingletonGetInstance(StringBuilder builder, Indent indent, String className) {
        builder.append(indent).append("private static volatile ").append(className).append(" sInstance = null;\n");
        builder.append(indent).append("public static ").append(className).append(" getInstance() {\n").append(indent.increment()).append(className).append(" local = sInstance;\n").append(indent).append("if (local == null) {\n").append(indent.increment()).append("synchronized (").append(className).append(".class) {\n").append(indent.increment()).append("local = sInstance;\n").append(indent).append("if (local == null) {\n").append(indent.increment()).append("final ContextProvider cp = SPGManager.getContextProvider();\n").append(indent).append("local = sInstance = new ").append(className).append("(cp.provide());\n").append(indent.decrement()).append("}\n").append(indent.decrement()).append("}\n").append(indent.decrement()).append("}\n").append(indent).append("return local;\n").append(indent.decrement()).append("}\n\n");
    }

    private static void writeLocalVariables(StringBuilder builder, Indent indent) {
        builder.append(indent).append("private final SharedPreferences prefs;\n").append(indent).append("private final SharedPreferences.Editor editor;\n\n");
    }

    private static void writeConstructor(StringBuilder builder, Indent indent, String className, boolean defaultName, int prefMode) {
        builder.append(indent).append("public ").append(className).append("(Context context) {\n").append(indent.increment());
        if (defaultName) {
            builder.append("this.prefs = PreferenceManager.getDefaultSharedPreferences(context);\n");
        } else {
            builder.append("this.prefs = context.getSharedPreferences(").append(CONST_PREF_NAME).append(", ").append(prefMode).append(");\n");
        }
        builder.append(indent).append("this.editor = prefs.edit();\n").append(indent.decrement()).append("}\n\n");
    }

    private static void writeGetters(StringBuilder builder, Indent indent, List<KeyHolder> keys) {
        for (KeyHolder key : keys) {
            Element e = key.element;
            TypeMirror typeMirror = e.asType();
            boolean isBool = key.keyType == KeyType.BOOL;
            builder.append(indent).append("public ").append(typeMirror).append(' ').append(isBool ? MethodNameUtils.createBooleanGetter(key.fieldName) : MethodNameUtils.createGetter(key.fieldName)).append("() {\n");
            indent.increment();
            KeyType type = key.keyType;
            if (type != null) {
                String defValue = SPGPreferenceWriter.createDefValue(type, key.defItem);
                builder.append(indent).append("return ").append(SPGPreferenceWriter.createPrefGetStatement(type, key.name, defValue)).append(";\n");
            } else {
                SerializerHolder serializer = key.serializer;
                String defValue = SPGPreferenceWriter.createDefValue(serializer.keyType, key.defItem);
                builder.append(indent).append(serializer.name).append(" s = ").append("SPGManager.getSerializer(").append(serializer.name).append(".class);\n").append(indent).append("if (s == null) {\n").append(indent.increment()).append("s = new ").append(serializer.name).append("();\n").append(indent).append("SPGManager.addSerializer(s);\n").append(indent.decrement()).append("}\n").append(indent).append("return s.deserialize(").append(SPGPreferenceWriter.createPrefGetStatement(serializer.keyType, key.name, defValue)).append(");\n");
            }
            builder.append(indent.decrement()).append("}\n\n");
        }
    }

    private static String createDefValue(KeyType type, DefItem item) {
        if (item == null) {
            return SPGPreferenceWriter.createDefName(type);
        }
        if (type == KeyType.STRING && !item.isEvaluation) {
            return "\"" + item.value + "\"";
        }
        return item.value;
    }

    private static String createPrefGetStatement(KeyType keyType, String key, String value) {
        switch (keyType) {
            case INT: {
                return "prefs.getInt(\"" + key + "\", " + value + ")";
            }
            case LONG: {
                return "prefs.getLong(\"" + key + "\", " + value + ")";
            }
            case BOOL: {
                return "prefs.getBoolean(\"" + key + "\", " + value + ")";
            }
            case FLOAT: {
                return "prefs.getFloat(\"" + key + "\", " + value + ")";
            }
            case STRING: {
                return "prefs.getString(\"" + key + "\", " + value + ")";
            }
        }
        return null;
    }

    private static String createClassName(Element element) {
        return element.getSimpleName().toString() + "Preference";
    }

    private static String createQualifiedName(TypeElement element) {
        return element.getQualifiedName().toString();
    }

    private static String createPackageStatement(String p) {
        return "package " + p;
    }

    private static void writeImports(StringBuilder builder, List<String> imports) {
        for (String ii : INITIAL_IMPORTS) {
            builder.append(SPGPreferenceWriter.createImportStatement(ii)).append('\n');
        }
        if (imports != null && imports.size() > 0) {
            for (String i : imports) {
                builder.append(SPGPreferenceWriter.createImportStatement(i)).append('\n');
            }
        }
        builder.append('\n');
    }

    private static String createImportStatement(String s) {
        return SPGPreferenceWriter.semicolon("import " + s);
    }

    private static void writeGenInfo(StringBuilder builder, TypeElement element) {
        builder.append(String.format(GEN_INFO_PATTERN, new Date(), element.getQualifiedName()));
    }

    private static void writeClassStatement(StringBuilder builder, String prefClassName, String entityClassName) {
        builder.append(String.format(CLASS_STATEMENT_PATTERN, prefClassName, entityClassName != null ? String.format(ENTITY_INTERFACE_PATTERN, entityClassName) : ""));
    }

    private static String createConstantStatement(KeyType type, String name, String value) {
        return SPGPreferenceWriter.semicolon(CONST_MODIFIERS + type.getRepr() + " " + name + " = " + value);
    }

    private static String createConstantStatementName(String path, String name) {
        StringBuilder builder = new StringBuilder(path);
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isUpperCase(name.charAt(i))) {
                builder.append('_');
            }
            builder.append(Character.toUpperCase(name.charAt(i)));
        }
        return builder.toString();
    }

    private static String semicolon(String in) {
        if (in.charAt(in.length() - 1) != ';') {
            return in + ';';
        }
        return in;
    }

    private static String createDefName(KeyType type) {
        return CONST_DEF + type.name();
    }

    private static void writeSetters(StringBuilder builder, Indent indent, PreferenceHolder holder) {
        for (KeyHolder key : holder.keys) {
            SPGPreferenceWriter.writeSetter(key, "void", builder, indent, true);
        }
    }

    private static void writeSetter(KeyHolder key, String methodReturnType, StringBuilder builder, Indent indent, boolean isApply) {
        Element element = key.element;
        TypeMirror type = element.asType();
        builder.append(indent).append("public ").append(methodReturnType).append(" ").append(MethodNameUtils.createSetter(key.fieldName)).append("(").append(type).append(" value) {\n").append(indent.increment());
        KeyType keyType = key.keyType;
        if (keyType != null) {
            builder.append(SPGPreferenceWriter.createSimpleSet(keyType, key.name, "value", isApply)).append(";");
        } else {
            String serializer = key.serializer.name;
            builder.append(serializer).append(" s = SPGManager.getSerializer(").append(serializer).append(".class);\n").append(indent).append("if (s == null) {\n").append(indent.increment()).append("s = new ").append(serializer).append("();\n").append(indent).append("SPGManager.addSerializer(s);\n").append(indent.decrement()).append("}\n").append(indent).append(SPGPreferenceWriter.createSimpleSet(key.serializer.keyType, key.name, "s.serialize(value)", isApply)).append(";");
        }
        builder.append("\n").append(indent.decrement()).append("}\n\n");
    }

    private static String createSimpleSet(KeyType type, String key, String value, boolean isApply) {
        String s;
        switch (type) {
            case INT: {
                s = "editor.putInt(\"" + key + "\", " + value + ")";
                break;
            }
            case BOOL: {
                s = "editor.putBoolean(\"" + key + "\", " + value + ")";
                break;
            }
            case LONG: {
                s = "editor.putLong(\"" + key + "\", " + value + ")";
                break;
            }
            case FLOAT: {
                s = "editor.putFloat(\"" + key + "\", " + value + ")";
                break;
            }
            case STRING: {
                s = "editor.putString(\"" + key + "\", " + value + ")";
                break;
            }
            default: {
                s = null;
            }
        }
        if (s != null && isApply) {
            return s + ".apply()";
        }
        return s;
    }

    private static void writeSPGObjectMethods(StringBuilder builder, Indent indent, PreferenceHolder preference) {
        SPGPreferenceWriter.writeToMapMethod(builder, indent, preference);
        SPGPreferenceWriter.writeSimpleGet(builder, indent, "SharedPreferences", "prefs", "sharedPreferences");
        SPGPreferenceWriter.writeSimpleGet(builder, indent, "SharedPreferences.Editor", "editor", "editor");
        SPGPreferenceWriter.writeSimpleGet(builder, indent, "String", CONST_PREF_NAME, "sharedPreferencesName");
        SPGPreferenceWriter.writeSimpleGet(builder, indent, "int", CONST_PREF_MODE, "sharedPreferencesMode");
        SPGPreferenceWriter.writeGenericGetMethod(builder, indent, preference);
        if (preference.toEntity) {
            SPGPreferenceWriter.writeGenericToEntityMethod(builder, indent, preference);
        }
    }

    private static void writeToMapMethod(StringBuilder builder, Indent indent, PreferenceHolder preference) {
        builder.append(indent).append("public Map<String, Object> toMap() {\n").append(indent.increment()).append("final Map<String, Object> map = new HashMap<String, Object>();\n");
        for (KeyHolder key : preference.keys) {
            boolean isBool = key.keyType == KeyType.BOOL;
            builder.append(indent).append("map.put(\"").append(key.name).append("\", ").append(isBool ? MethodNameUtils.createBooleanGetter(key.fieldName) : MethodNameUtils.createGetter(key.fieldName)).append("());\n");
        }
        builder.append(indent).append("return map;\n").append(indent.decrement()).append("}\n\n");
    }

    private static void writeSimpleGet(StringBuilder builder, Indent indent, String type, String localVarName, String reprString) {
        String method = MethodNameUtils.createGetter(reprString);
        builder.append(indent).append("public ").append(type).append(" ").append(method).append("() {\n").append(indent.increment()).append("return ").append(localVarName).append(";\n").append(indent.decrement()).append("}\n\n");
    }

    private static void writeGenericToEntityMethod(StringBuilder builder, Indent indent, PreferenceHolder holder) {
        String qualifiedName = SPGPreferenceWriter.createQualifiedName(holder.typeElement);
        builder.append(indent).append("public ").append(qualifiedName).append(" toEntity() {\n").append(indent.increment()).append("return new ").append(qualifiedName).append("(");
        Iterator<KeyHolder> iterator = holder.keys.iterator();
        while (iterator.hasNext()) {
            KeyHolder key = iterator.next();
            boolean isBool = key.keyType == KeyType.BOOL;
            builder.append(isBool ? MethodNameUtils.createBooleanGetter(key.fieldName) : MethodNameUtils.createGetter(key.fieldName)).append("()").append(iterator.hasNext() ? ", " : ");\n");
        }
        builder.append(indent.decrement()).append("}\n\n");
    }

    private static void writeGenericGetMethod(StringBuilder builder, Indent indent, PreferenceHolder holder) {
        builder.append(indent).append("public <T> T get(String key) {\n").append(indent.increment()).append("if (key == null) { return null; }\n").append(indent).append("final Object o;\n");
        boolean isFirst = true;
        for (KeyHolder key : holder.keys) {
            boolean isBool;
            boolean bl = isBool = key.keyType == KeyType.BOOL;
            if (!isFirst) {
                builder.append(" else ");
            } else {
                builder.append(indent);
                isFirst = false;
            }
            builder.append("if (key.equals(\"").append(key.name).append("\")) {\n").append(indent.increment()).append("o = ").append(isBool ? MethodNameUtils.createBooleanGetter(key.fieldName) : MethodNameUtils.createGetter(key.fieldName)).append("();\n").append(indent.decrement()).append("}");
        }
        builder.append(" else {\n").append(indent.increment()).append("// not in this prefs;\n").append(indent).append("o = null;\n").append(indent.decrement()).append("}\n");
        builder.append(indent).append("return (T) o;\n").append(indent.decrement()).append("}\n\n");
    }

    private static void writeSetterClass(StringBuilder builder, Indent indent, PreferenceHolder holder) {
        builder.append(indent).append("public Setter setter() {\n").append(indent.increment()).append("return new Setter(editor);\n").append(indent.decrement()).append("}\n\n");
        builder.append(indent).append("public static final class Setter {\n\n");
        indent.increment();
        builder.append(indent).append("private final SharedPreferences.Editor editor;\n\n").append(indent).append("Setter(SharedPreferences.Editor editor) {\n").append(indent.increment()).append("this.editor = editor;\n").append(indent.decrement()).append("}\n\n");
        for (KeyHolder key : holder.keys) {
            SPGPreferenceWriter.writeSetter(key, "Setter", builder, indent, false);
            int index = builder.lastIndexOf("}");
            String insert = indent.decrement().toString() + "return this;\n" + indent.increment().toString();
            builder.insert(index, insert);
        }
        builder.append(indent).append("public void apply() { editor.apply(); }\n").append(indent.decrement()).append("}\n\n");
    }

    private static void writeOnUpdate(StringBuilder builder, Indent indent, PreferenceHolder holder) {
        boolean hasOnUpdate = false;
        for (KeyHolder key : holder.keys) {
            if (!key.onUpdate) continue;
            hasOnUpdate = true;
            builder.append(indent).append("public void ").append(MethodNameUtils.createSetter(key.fieldName)).append("UpdateListener(OnUpdateListener listener) {\n").append(indent.increment()).append("updateListeners.put(\"").append(key.name).append("\", listener);\n").append(indent).append("checkSharedListener();\n").append(indent.decrement()).append("}\n\n");
        }
        if (hasOnUpdate) {
            builder.append(indent).append("private final java.util.Map<String, OnUpdateListener> updateListeners;\n").append(indent).append("private final SharedPreferences.OnSharedPreferenceChangeListener sharedListener;\n").append(indent).append("private boolean isListenerRegistered;").append(indent).append("{\n").append(indent.increment()).append("updateListeners = new java.util.HashMap<String, OnUpdateListener>();\n").append(indent).append("sharedListener = new SharedPreferences.OnSharedPreferenceChangeListener() {\n").append(indent.increment()).append("public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {\n").append(indent.increment()).append("final OnUpdateListener listener = updateListeners.get(key);\n").append(indent).append("if (listener != null) { listener.onUpdate(); }\n").append(indent.decrement()).append("}\n").append(indent.decrement()).append("};\n").append(indent.decrement()).append("}\n\n");
            builder.append(indent).append("private void checkSharedListener() {\n").append(indent.increment()).append("if (!isListenerRegistered) {\n").append(indent.increment()).append("prefs.registerOnSharedPreferenceChangeListener(sharedListener);\n").append(indent).append("isListenerRegistered = true;\n").append(indent.decrement()).append("}\n").append(indent.decrement()).append("}\n\n");
        }
    }
}

